/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Set;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.OpenFile;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.Stat;

public class ReadOnlyFileHandler
implements Closeable {
    protected final OpenFileFactory openFiles;

    public ReadOnlyFileHandler(OpenFileFactory openFiles) {
        this.openFiles = openFiles;
    }

    public void open(Path path, FileInfo fi) throws IOException {
        Set openOptions = fi.getOpenFlags();
        long fileHandle = this.open(path, openOptions);
        fi.setFh(fileHandle);
    }

    protected long open(Path path, Set<StandardOpenOption> openOptions) throws AccessDeniedException, IOException {
        if (openOptions.contains(StandardOpenOption.WRITE)) {
            throw new AccessDeniedException(path.toString(), null, "Unsupported open options: WRITE");
        }
        return this.openFiles.open(path, StandardOpenOption.READ);
    }

    public int read(ByteBuffer buf, long size, long offset, FileInfo fi) throws IOException {
        OpenFile file = this.openFiles.get(fi.getFh());
        if (file == null) {
            throw new ClosedChannelException();
        }
        return file.read(buf, size, offset);
    }

    public void release(FileInfo fi) throws IOException {
        this.openFiles.close(fi.getFh());
    }

    public int getattr(Path node, BasicFileAttributes attrs, Stat stat) {
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            stat.setPermissions(posixAttrs.permissions());
        } else {
            stat.setMode(365);
        }
        FileAttributesUtil.copyBasicFileAttributesFromNioToFuse(attrs, stat);
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.openFiles.close();
    }
}

