/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import org.cryptomator.frontend.fuse.FileChannelUtil;
import org.cryptomator.frontend.fuse.OpenFile;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.frontend.fuse.ReadOnlyFileHandler;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.TimeSpec;

public class ReadWriteFileHandler
extends ReadOnlyFileHandler
implements Closeable {
    public ReadWriteFileHandler(OpenFileFactory openFiles) {
        super(openFiles);
    }

    @Override
    public int getattr(Path node, BasicFileAttributes attrs, Stat stat) {
        int result = super.getattr(node, attrs, stat);
        if (result == 0 && attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            stat.setPermissions(posixAttrs.permissions());
        } else if (result == 0) {
            stat.setModeBits(511);
        }
        return result;
    }

    public void createAndOpen(Path path, FileInfo fi, FileAttribute<?> ... attrs) throws IOException {
        long fileHandle = this.openFiles.open(path, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE), attrs);
        fi.setFh(fileHandle);
    }

    @Override
    protected long open(Path path, Set<StandardOpenOption> openOptions) throws IOException {
        return this.openFiles.open(path, openOptions, new FileAttribute[0]);
    }

    public int write(ByteBuffer buf, long size, long offset, FileInfo fi) throws IOException {
        OpenFile file = this.openFiles.get(fi.getFh());
        if (file == null) {
            throw new ClosedChannelException();
        }
        return file.write(buf, size, offset);
    }

    public void fsync(FileInfo fi, boolean metaData) throws IOException {
        OpenFile file = this.openFiles.get(fi.getFh());
        if (file == null) {
            throw new ClosedChannelException();
        }
        file.fsync(metaData);
    }

    public void truncate(Path path, long size) throws IOException {
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.WRITE);){
            FileChannelUtil.truncateOrExpand(fc, size);
        }
    }

    public void ftruncate(long size, FileInfo fi) throws IOException {
        OpenFile file = this.openFiles.get(fi.getFh());
        if (file == null) {
            throw new ClosedChannelException();
        }
        file.truncate(size);
    }

    public void utimens(Path node, TimeSpec mTimeSpec, TimeSpec aTimeSpec) throws IOException {
        FileTime mTime = mTimeSpec.getOptional().map(FileTime::from).orElse(null);
        FileTime aTime = aTimeSpec.getOptional().map(FileTime::from).orElse(null);
        BasicFileAttributeView view = Files.getFileAttributeView(node, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        view.setTimes(mTime, aTime, null);
    }
}

