/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.locks;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.cryptomator.frontend.fuse.locks.AlreadyLockedException;
import org.cryptomator.frontend.fuse.locks.FilePaths;
import org.cryptomator.frontend.fuse.locks.PathLock;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final LoadingCache<List<String>, ReadWriteLock> pathLocks;
    private final LoadingCache<List<String>, ReadWriteLock> dataLocks;

    public LockManager() {
        Caffeine cacheBuilder = Caffeine.newBuilder().weakValues();
        if (LOG.isDebugEnabled()) {
            cacheBuilder.removalListener(this::removedReadWriteLock);
        }
        this.pathLocks = cacheBuilder.build(this::createReadWriteLock);
        this.dataLocks = cacheBuilder.build(this::createReadWriteLock);
    }

    public PathLock tryLockForWriting(String path) throws AlreadyLockedException {
        List<String> pathComponents = FilePaths.toComponents(path);
        PathLock lock = this.lock(pathComponents, PathLock::tryWriteLock);
        if (lock != null) {
            return lock;
        }
        throw new AlreadyLockedException();
    }

    public PathLock lockForReading(String path) {
        List<String> pathComponents = FilePaths.toComponents(path);
        return this.lock(pathComponents, PathLock::readLock);
    }

    public PathLock lockForWriting(String path) {
        List<String> pathComponents = FilePaths.toComponents(path);
        return this.lock(pathComponents, PathLock::writeLock);
    }

    @Nullable
    private PathLock lock(List<String> pathComponents, PathLock.Factory factory) {
        if (pathComponents.isEmpty()) {
            return null;
        }
        List<String> parentPathComponents = FilePaths.parentPathComponents(pathComponents);
        PathLock parentLock = this.lock(parentPathComponents, PathLock::readLock);
        ReadWriteLock rwLock = (ReadWriteLock)this.pathLocks.get(pathComponents);
        Supplier<ReadWriteLock> dataLockSupplier = () -> (ReadWriteLock)this.dataLocks.get((Object)pathComponents);
        return factory.lock(pathComponents, parentLock, rwLock, dataLockSupplier);
    }

    private ReadWriteLock createReadWriteLock(List<String> key) {
        LOG.trace("Creating ReadWriteLock for {}", key);
        return new ReentrantReadWriteLock();
    }

    private void removedReadWriteLock(List<String> key, ReentrantReadWriteLock value, RemovalCause removalCause) {
        LOG.trace("Deleting ReadWriteLock for {}", key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isPathLocked(String path) {
        ReadWriteLock lock = (ReadWriteLock)this.pathLocks.getIfPresent(FilePaths.toComponents(path));
        if (lock == null) {
            return false;
        }
        if (lock.writeLock().tryLock()) {
            try {
                boolean bl = false;
                return bl;
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return true;
    }
}

