/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.cryptofs.event.BrokenDirFileEvent;
import org.cryptomator.cryptofs.event.BrokenFileNodeEvent;
import org.cryptomator.cryptofs.event.ConflictResolutionFailedEvent;
import org.cryptomator.cryptofs.event.ConflictResolvedEvent;
import org.cryptomator.cryptofs.event.DecryptionFailedEvent;
import org.cryptomator.cryptofs.event.FilesystemEvent;
import org.cryptomator.event.VaultEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class EventMap
implements ObservableMap<EventKey, VaultEvent> {
    private static final int MAX_SIZE = 300;
    private final ObservableMap<EventKey, VaultEvent> delegate = FXCollections.observableHashMap();

    @Inject
    public EventMap() {
    }

    public void addListener(MapChangeListener<? super EventKey, ? super VaultEvent> mapChangeListener) {
        this.delegate.addListener(mapChangeListener);
    }

    public void removeListener(MapChangeListener<? super EventKey, ? super VaultEvent> mapChangeListener) {
        this.delegate.removeListener(mapChangeListener);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public VaultEvent get(Object key) {
        return (VaultEvent)this.delegate.get(key);
    }

    @Nullable
    public VaultEvent put(EventKey key, VaultEvent value) {
        return (VaultEvent)this.delegate.put((Object)key, (Object)value);
    }

    public VaultEvent remove(Object key) {
        return (VaultEvent)this.delegate.remove(key);
    }

    public void putAll(@NotNull Map<? extends EventKey, ? extends VaultEvent> m) {
        this.delegate.putAll(m);
    }

    public void clear() {
        this.delegate.clear();
    }

    @NotNull
    public Set<EventKey> keySet() {
        return this.delegate.keySet();
    }

    @NotNull
    public Collection<VaultEvent> values() {
        return this.delegate.values();
    }

    @NotNull
    public Set<Map.Entry<EventKey, VaultEvent>> entrySet() {
        return this.delegate.entrySet();
    }

    public void addListener(InvalidationListener invalidationListener) {
        this.delegate.addListener(invalidationListener);
    }

    public void removeListener(InvalidationListener invalidationListener) {
        this.delegate.removeListener(invalidationListener);
    }

    public synchronized void put(VaultEvent e) {
        EventKey key = this.computeKey(e.actualEvent());
        VaultEvent nullOrEntry = (VaultEvent)this.delegate.get((Object)key);
        if (nullOrEntry == null) {
            if (this.size() == 300) {
                this.delegate.entrySet().stream().min(Comparator.comparing(entry -> ((VaultEvent)entry.getValue()).actualEvent().getTimestamp())).ifPresent(oldestEntry -> this.delegate.remove(oldestEntry.getKey()));
            }
            this.delegate.put((Object)key, (Object)e);
        } else {
            this.delegate.put((Object)key, (Object)nullOrEntry.incrementCount(e.actualEvent()));
        }
    }

    public synchronized VaultEvent remove(VaultEvent similar) {
        EventKey key = this.computeKey(similar.actualEvent());
        return this.remove(key);
    }

    /*
     * Loose catch block
     */
    private EventKey computeKey(FilesystemEvent e) {
        FilesystemEvent filesystemEvent = e;
        Objects.requireNonNull(filesystemEvent);
        FilesystemEvent filesystemEvent2 = filesystemEvent;
        int n = 0;
        Object p = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DecryptionFailedEvent.class, ConflictResolvedEvent.class, ConflictResolutionFailedEvent.class, BrokenDirFileEvent.class, BrokenFileNodeEvent.class}, (FilesystemEvent)filesystemEvent2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                DecryptionFailedEvent var5_5 = (DecryptionFailedEvent)filesystemEvent2;
                Object var7_6 = var5_5.timestamp();
                Object ciphertextPath = var7_6 = var5_5.ciphertextPath();
                var7_6 = var5_5.e();
                yield ciphertextPath;
            }
            case 1 -> {
                Object var7_6 = (ConflictResolvedEvent)filesystemEvent2;
                Object var9_8 = var7_6.timestamp();
                var9_8 = var7_6.canonicalCleartextPath();
                var9_8 = var7_6.conflictingCiphertextPath();
                var9_8 = var7_6.resolvedCleartextPath();
                Object resolvedCiphertext = var9_8 = var7_6.resolvedCiphertextPath();
                yield resolvedCiphertext;
            }
            case 2 -> {
                Object var9_8 = (ConflictResolutionFailedEvent)filesystemEvent2;
                Object var11_10 = var9_8.timestamp();
                var11_10 = var9_8.canonicalCleartextPath();
                Object conflictingCiphertext = var11_10 = var9_8.conflictingCiphertextPath();
                var11_10 = var9_8.reason();
                yield conflictingCiphertext;
            }
            case 3 -> {
                Object ciphertext;
                Object var11_10 = (BrokenDirFileEvent)filesystemEvent2;
                Object var13_12 = var11_10.timestamp();
                yield ciphertext = (var13_12 = var11_10.ciphertextPath());
            }
            case 4 -> {
                Object var13_12 = (BrokenFileNodeEvent)filesystemEvent2;
                Comparable<Instant> var15_14 = var13_12.timestamp();
                var15_14 = var13_12.cleartextPath();
                Comparable<Instant> ciphertext = var15_14 = var13_12.ciphertextPath();
                yield ciphertext;
            }
        };
        return new EventKey((Path)p, e.getClass());
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public record EventKey(Path ciphertextPath, Class<? extends FilesystemEvent> c) {
    }
}

