/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import java.util.Arrays;
import javax.security.auth.Destroyable;

public class Passphrase
implements Destroyable,
CharSequence {
    private final char[] data;
    private final int offset;
    private final int length;
    private boolean destroyed;

    public Passphrase(char[] data) {
        this(data, 0, data.length);
    }

    public Passphrase(char[] data, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IndexOutOfBoundsException("[%1$d %1$d + %2$d[ not within [0, %3$d[".formatted(offset, length, data.length));
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public static Passphrase copyOf(CharSequence cs) {
        char[] result = new char[cs.length()];
        for (int i = 0; i < cs.length(); ++i) {
            result[i] = cs.charAt(i);
        }
        return new Passphrase(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Passphrase that = (Passphrase)o;
        int diff = 0;
        for (int i = 0; i < this.length; ++i) {
            diff |= this.charAt(i) ^ that.charAt(i);
        }
        return diff == 0;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.charAt(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return new String(this.data, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("%d not within [0, %d[".formatted(index, this.length));
        }
        return this.data[this.offset + index];
    }

    @Override
    public Passphrase subSequence(int start, int end) {
        if (start < 0 || end < 0 || end > this.length || start > end) {
            throw new IndexOutOfBoundsException("[%d, %d[ not within [0, %d[".formatted(start, end, this.length));
        }
        return new Passphrase(Arrays.copyOfRange(this.data, this.offset + start, this.offset + end));
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        Arrays.fill(this.data, this.offset, this.offset + this.length, '\u0000');
        this.destroyed = true;
    }
}

