/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common;

import java.util.Map;
import java.util.Properties;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cryptomator.common.PropertiesDecorator;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.LoggerFactory;

public class SubstitutingProperties
extends PropertiesDecorator {
    private static final Pattern TEMPLATE = Pattern.compile("@\\{(\\w+)}");
    private final Map<String, String> env;

    public SubstitutingProperties(Properties props, Map<String, String> systemEnvironment) {
        super(props);
        this.env = systemEnvironment;
    }

    @Override
    public String getProperty(String key) {
        String value = this.delegate.getProperty(key);
        if (key.startsWith("cryptomator.") && value != null) {
            return this.process(value);
        }
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        return result != null ? result : defaultValue;
    }

    @VisibleForTesting
    String process(String value) {
        return TEMPLATE.matcher(value).replaceAll((MatchResult match) -> switch (match.group(1)) {
            case "appdir" -> this.resolveFrom("APPDIR", Source.ENV);
            case "appdata" -> this.resolveFrom("APPDATA", Source.ENV);
            case "localappdata" -> this.resolveFrom("LOCALAPPDATA", Source.ENV);
            case "userhome" -> this.resolveFrom("user.home", Source.PROPS);
            default -> {
                LoggerFactory.getLogger(SubstitutingProperties.class).warn("Unknown variable {} in property value {}.", (Object)match.group(), (Object)value);
                yield match.group();
            }
        });
    }

    private String resolveFrom(String key, Source src) {
        String val;
        switch (src.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String string = this.env.get(key);
                break;
            }
            case 1: {
                String string = val = this.delegate.getProperty(key);
            }
        }
        if (val == null) {
            LoggerFactory.getLogger(SubstitutingProperties.class).warn("Variable {} used for substitution not found in {}. Replaced with empty string.", (Object)key, (Object)src);
            return "";
        }
        return Matcher.quoteReplacement(val);
    }

    private static enum Source {
        ENV,
        PROPS;

    }
}

