/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.locationpresets;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.cryptomator.common.locationpresets.LocationPreset;
import org.cryptomator.common.locationpresets.LocationPresetsProvider;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;

@OperatingSystem(value=OperatingSystem.Value.MAC)
@CheckAvailability
public final class GoogleDriveMacLocationPresetsProvider
implements LocationPresetsProvider {
    private static final Path ROOT_LOCATION = LocationPresetsProvider.resolveLocation("~/Library/CloudStorage/").toAbsolutePath();
    private static final Predicate<String> PATTERN = Pattern.compile("^GoogleDrive-[^/]+$").asMatchPredicate();
    private static final List<Path> FALLBACK_LOCATIONS = List.of(LocationPresetsProvider.resolveLocation("~/GoogleDrive/My Drive"), LocationPresetsProvider.resolveLocation("~/Google Drive/My Drive"), LocationPresetsProvider.resolveLocation("~/GoogleDrive"), LocationPresetsProvider.resolveLocation("~/Google Drive"));
    private static final Set<String> MY_DRIVE_TRANSLATIONS = Set.of("My Drive", "\u12e8\u12a5\u1294 Drive", "\u0645\u0644\u0641\u0627\u062a\u064a", "\u09ae\u09cb\u09f0 \u09a1\u09cd\u09f0\u09be\u0987\u09ad", "Diskim", "\u041c\u043e\u0439 \u0414\u044b\u0441\u043a", "\u041c\u043e\u044f\u0442 \u0434\u0438\u0441\u043a", "\u0986\u09ae\u09be\u09b0 \u09a1\u09cd\u09b0\u09be\u0987\u09ad", "Moj disk", "La meva unitat", "M\u016fj disk", "Mit drev", "Meine Ablage", "\u03a4\u03bf Drive \u03bc\u03bf\u03c5", "Mi unidad", "Minu ketas", "Nire unitatea", "Aking Drive", "Oma Drive", "Mon disque", "Mon Drive", "A mi\u00f1a unidade", "\u0aae\u0abe\u0ab0\u0ac0 \u0aa1\u0acd\u0ab0\u0abe\u0a87\u0ab5", "\u092e\u0947\u0930\u0940 \u0921\u094d\u0930\u093e\u0907\u0935", "Saj\u00e1t meghajt\u00f3", "\u053b\u0574 \u0564\u0580\u0561\u0575\u057e\u0568", "Drive Saya", "Drifi\u00f0 mitt", "I miei file", "\u05d4\u05d0\u05d7\u05e1\u05d5\u05df \u05e9\u05dc\u05d9", "\u30de\u30a4\u30c9\u30e9\u30a4\u30d6", "\u10e9\u10d4\u10db\u10d8 Drive", "\u041c\u0435\u043d\u0456\u04a3 Drive \u0434\u0438\u0441\u043a\u0456\u043c", "\u178a\u17d2\u179a\u17b6\u1799\u179a\u1794\u179f\u17cb\u1781\u17d2\u1789\u17bb\u17c6", "\u0ca8\u0ca8\u0ccd\u0ca8 \u0ca1\u0ccd\u0cb0\u0cc6\u0cd6\u0cb5\u0ccd", "\ub0b4 \ub4dc\ub77c\uc774\ube0c", "\u041c\u0435\u043d\u0438\u043d Drive'\u044b\u043c", "Mano Diskas", "Mans disks", "\u041c\u043e\u0458\u043e\u0442 Drive", "\u0d0e\u0d28\u0d4d\u0d31\u0d46 \u0d21\u0d4d\u0d30\u0d48\u0d35\u0d4d", "\u041c\u0438\u043d\u0438\u0439 \u0414\u0440\u0430\u0439\u0432", "\u092e\u093e\u091d\u093e \u0921\u094d\u0930\u093e\u0907\u0935\u094d\u0939", "\u092e\u0947\u0930\u094b \u0921\u094d\u0930\u093e\u0907\u092d", "Mijn Drive", "Min disk", "\u0b2e\u0b4b \u0b21\u0b4d\u0b30\u0b3e\u0b07\u0b2d\u0b4d", "M\u00f3j dysk", "Meu Drive", "O meu disco", "Contul meu Drive", "\u041c\u043e\u0439 \u0434\u0438\u0441\u043a", "\u0db8\u0d9c\u0dda Drive", "M\u00f4j disk", "Disku im", "\u041c\u043e\u0458 \u0434\u0438\u0441\u043a", "Min enhet", "Hifadhi Yangu", "\u0b8e\u0ba9\u0ba4\u0bc1 \u0b87\u0baf\u0b95\u0bcd\u0b95\u0b95\u0bae\u0bcd", "\u0c28\u0c3e \u0c21\u0c4d\u0c30\u0c48\u0c35\u0c4d\u200c", "\u0e44\u0e14\u0e23\u0e1f\u0e4c\u0e02\u0e2d\u0e07\u0e09\u0e31\u0e19", "Drive'\u0131m", "\u041c\u0456\u0439 \u0434\u0438\u0441\u043a", "\u0645\u06cc\u0631\u06cc \u0688\u0631\u0627\u0626\u06cc\u0648", "Drive c\u1ee7a t\u00f4i", "\u6211\u7684\u4e91\u7aef\u786c\u76d8", "\u6211\u7684\u96f2\u7aef\u786c\u789f", "IDrayivu yami");

    @Override
    public Stream<LocationPreset> getLocations() {
        List<LocationPreset> cloudStorageDirLocations = this.getCloudStorageDirLocations();
        return cloudStorageDirLocations.isEmpty() ? this.getFallbackLocation().stream() : cloudStorageDirLocations.stream();
    }

    @CheckAvailability
    public static boolean isPresent() {
        return GoogleDriveMacLocationPresetsProvider.isRootLocationPresent() || FALLBACK_LOCATIONS.stream().anyMatch(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    public static boolean isRootLocationPresent() {
        boolean bl;
        block8: {
            Stream<Path> dirStream = Files.list(ROOT_LOCATION);
            try {
                bl = dirStream.anyMatch(path -> Files.isDirectory(path, new LinkOption[0]) && PATTERN.test(path.getFileName().toString()));
                if (dirStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    return false;
                }
            }
            dirStream.close();
        }
        return bl;
    }

    private String getDriveLocationString(Path accountPath) {
        String accountName = accountPath.getFileName().toString().replace("GoogleDrive-", "");
        return "Google Drive - " + accountName;
    }

    private List<LocationPreset> getCloudStorageDirLocations() {
        List<LocationPreset> list;
        block8: {
            Stream<Path> dirStream = Files.list(ROOT_LOCATION);
            try {
                list = dirStream.filter(path -> Files.isDirectory(path, new LinkOption[0]) && PATTERN.test(path.getFileName().toString())).flatMap(this::getPresetsFromAccountPath).toList();
                if (dirStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    return List.of();
                }
            }
            dirStream.close();
        }
        return list;
    }

    private Stream<LocationPreset> getPresetsFromAccountPath(Path accountPath) {
        Stream<LocationPreset> stream;
        block8: {
            Stream<Path> driveStream = Files.list(accountPath);
            try {
                stream = driveStream.filter(preset -> MY_DRIVE_TRANSLATIONS.contains(preset.getFileName().toString())).map(drivePath -> new LocationPreset(this.getDriveLocationString(accountPath), (Path)drivePath)).toList().stream();
                if (driveStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (driveStream != null) {
                        try {
                            driveStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Stream.empty();
                }
            }
            driveStream.close();
        }
        return stream;
    }

    @Deprecated
    private List<LocationPreset> getFallbackLocation() {
        return FALLBACK_LOCATIONS.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(location -> new LocationPreset("Google Drive", (Path)location)).findFirst().stream().toList();
    }
}

