/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.locationpresets;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.cryptomator.common.locationpresets.LocationPreset;
import org.cryptomator.common.locationpresets.LocationPresetsProvider;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;

@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
@CheckAvailability
public final class GoogleDriveWindowsLocationPresetsProvider
implements LocationPresetsProvider {
    private static final List<Path> LOCATIONS = Arrays.asList(LocationPresetsProvider.resolveLocation("~/GoogleDrive/My Drive"), LocationPresetsProvider.resolveLocation("~/Google Drive/My Drive"), LocationPresetsProvider.resolveLocation("~/GoogleDrive"), LocationPresetsProvider.resolveLocation("~/Google Drive"));

    @CheckAvailability
    public static boolean isPresent() {
        return LOCATIONS.stream().anyMatch(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
    }

    @Override
    public Stream<LocationPreset> getLocations() {
        return LOCATIONS.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(location -> new LocationPreset("Google Drive", (Path)location)).findFirst().stream();
    }
}

