/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.locationpresets;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptomator.common.locationpresets.LocationPreset;
import org.cryptomator.common.locationpresets.LocationPresetsProvider;
import org.cryptomator.integrations.common.OperatingSystem;
import org.jetbrains.annotations.Blocking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public final class OneDriveWindowsLocationPresetsProvider
implements LocationPresetsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OneDriveWindowsLocationPresetsProvider.class);
    private static final String REGSTR_TOKEN = "REG_SZ";
    private static final String REG_ONEDRIVE_ACCOUNTS = "HKEY_CURRENT_USER\\Software\\Microsoft\\OneDrive\\Accounts\\";

    @Override
    public Stream<LocationPreset> getLocations() {
        try {
            List<String> accountRegKeys = this.queryRegistry(REG_ONEDRIVE_ACCOUNTS, List.of(), l -> l.startsWith(REG_ONEDRIVE_ACCOUNTS)).toList();
            ArrayList<LocationPreset> cloudLocations = new ArrayList<LocationPreset>();
            for (String accountRegKey : accountRegKeys) {
                Path path = this.queryRegistry(accountRegKey, List.of("/v", "UserFolder"), l -> l.contains("UserFolder")).map(result -> result.substring(result.indexOf(REGSTR_TOKEN) + REGSTR_TOKEN.length()).trim()).map(x$0 -> Path.of(x$0, new String[0])).findFirst().orElseThrow();
                String name = "OneDrive";
                if (!accountRegKey.endsWith("Personal")) {
                    name = this.queryRegistry(accountRegKey, List.of("/v", "DisplayName"), l -> l.contains("DisplayName")).map(result -> result.substring(result.indexOf(REGSTR_TOKEN) + REGSTR_TOKEN.length()).trim()).map("OneDrive - "::concat).findFirst().orElseThrow();
                }
                cloudLocations.add(new LocationPreset(name, path));
            }
            return cloudLocations.stream();
        }
        catch (IOException | TimeoutException | CommandFailedException e) {
            LOG.error("Unable to determine OneDrive location", (Throwable)e);
            return Stream.of(new LocationPreset[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Determination of OneDrive location interrupted", (Throwable)e);
            return Stream.of(new LocationPreset[0]);
        }
    }

    private Stream<String> queryRegistry(String keyname, List<String> moreArgs, Predicate<String> outputFilter) throws InterruptedException, CommandFailedException, TimeoutException, IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("reg");
        args.add("query");
        args.add(keyname);
        args.addAll(moreArgs);
        ProcessBuilder command = new ProcessBuilder(args);
        Process p = command.start();
        OneDriveWindowsLocationPresetsProvider.waitForSuccess(p, 3, "`reg query`");
        return p.inputReader(StandardCharsets.ISO_8859_1).lines().filter(outputFilter);
    }

    @Blocking
    private static void waitForSuccess(Process process, int timeoutSeconds, String cmdDescription) throws TimeoutException, InterruptedException, CommandFailedException {
        boolean exited = process.waitFor(timeoutSeconds, TimeUnit.SECONDS);
        if (!exited) {
            throw new TimeoutException(cmdDescription + " timed out after " + timeoutSeconds + "s");
        }
        if (process.exitValue() != 0) {
            String stdout = process.inputReader(StandardCharsets.ISO_8859_1).lines().collect(Collectors.joining("\n"));
            String stderr = process.errorReader(StandardCharsets.ISO_8859_1).lines().collect(Collectors.joining("\n"));
            throw new CommandFailedException(cmdDescription, process.exitValue(), stdout, stderr);
        }
    }

    private static class CommandFailedException
    extends Exception {
        int exitCode;
        String stdout;
        String stderr;

        private CommandFailedException(String cmdDescription, int exitCode, String stdout, String stderr) {
            super(cmdDescription + " returned with non-zero exit code " + exitCode);
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

