/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.recovery;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import org.cryptomator.common.Constants;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoader;

public final class CryptoFsInitializer {
    private CryptoFsInitializer() {
    }

    public static void init(Path recoveryPath, Masterkey masterkey, int shorteningThreshold, CryptorProvider.Scheme scheme) throws IOException, CryptoException {
        MasterkeyLoader loader = ignored -> masterkey.copy();
        CryptoFileSystemProperties fsProps = CryptoFileSystemProperties.cryptoFileSystemProperties().withCipherCombo(scheme).withKeyLoader(loader).withShorteningThreshold(shorteningThreshold).build();
        CryptoFileSystemProvider.initialize((Path)recoveryPath, (CryptoFileSystemProperties)fsProps, (URI)Constants.DEFAULT_KEY_ID);
    }
}

