/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.launcher;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SupportedLanguages {
    private static final Logger LOG = LoggerFactory.getLogger(SupportedLanguages.class);
    public static final List<String> LANGUAGE_TAGS = List.of("ar", "be", "bn", "bs", "ca", "cs", "da", "de", "el", "es", "fr", "gl", "he", "hi", "hr", "hu", "id", "it", "ja", "ko", "lv", "nb", "nl", "nn", "pa", "pl", "pt", "pt-BR", "ro", "ru", "sk", "sr", "sr-Latn", "sv", "sw", "ta", "th", "tr", "ug", "uk", "vi", "zh", "zh-HK", "zh-TW");
    public static final String ENGLISH = "en";
    private final List<String> sortedLanguageTags;
    private final Locale preferredLocale;

    @Inject
    public SupportedLanguages(Settings settings) {
        String preferredLanguage = (String)settings.language.get();
        this.preferredLocale = preferredLanguage == null ? Locale.getDefault() : Locale.forLanguageTag(preferredLanguage);
        Collator collator = Collator.getInstance(this.preferredLocale);
        collator.setStrength(0);
        ArrayList<String> sorted = new ArrayList<String>();
        sorted.add(0, null);
        sorted.add(1, ENGLISH);
        LANGUAGE_TAGS.stream().sorted((a, b) -> collator.compare(Locale.forLanguageTag(a).getDisplayName(), Locale.forLanguageTag(b).getDisplayName())).forEach(sorted::add);
        this.sortedLanguageTags = Collections.unmodifiableList(sorted);
    }

    public void applyPreferred() {
        LOG.debug("Using locale {}", (Object)this.preferredLocale);
        Locale.setDefault(this.preferredLocale);
    }

    public List<String> getLanguageTags() {
        return this.sortedLanguageTags;
    }
}

