/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.FileSize;
import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.common.Environment;
import org.cryptomator.logging.LaunchAndSizeBasedTriggeringPolicy;

@ConfiguratorRank(value=30)
public class LogbackConfigurator
extends ContextAwareBase
implements Configurator {
    private static final String LOG_PATTERN = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
    private static final String UPGRADE_FILENAME = "upgrade.log";
    private static final String LOGFILE_NAME = "cryptomator0.log";
    private static final String LOGFILE_ROLLING_PATTERN = "cryptomator%i.log";
    private static final int LOGFILE_ROLLING_MIN = 1;
    private static final int LOGFILE_ROLLING_MAX = 9;
    private static final String LOG_MAX_SIZE = "100mb";
    static final Map<String, Level> DEFAULT_LOG_LEVELS = Map.of("ROOT", Level.INFO, "org.cryptomator", Level.INFO);
    static final Map<String, Level> DEBUG_LOG_LEVELS = Map.of("ROOT", Level.INFO, "org.cryptomator", Level.TRACE);

    LogbackConfigurator() {
    }

    void setLogLevels(Map<String, Level> logLevels) {
        Context context = this.context;
        if (context instanceof LoggerContext) {
            LoggerContext lc = (LoggerContext)context;
            for (Map.Entry entry : logLevels.entrySet()) {
                Logger logger = lc.getLogger((String)entry.getKey());
                logger.setLevel((Level)entry.getValue());
            }
        }
    }

    public Configurator.ExecutionStatus configure(LoggerContext context) {
        boolean useCustomCfg = Environment.getInstance().useCustomLogbackConfig();
        Path logDir = Environment.getInstance().getLogDir().orElse(null);
        if (useCustomCfg) {
            this.addInfo("Using external logback configuration file.");
        } else {
            Appender<ILoggingEvent> stdout = this.stdOutAppender(context);
            Appender<ILoggingEvent> noop = this.noopAppender(context);
            Appender<ILoggingEvent> file = logDir == null ? noop : this.fileAppender(context, logDir);
            Appender<ILoggingEvent> upgrade = logDir == null ? noop : this.upgradeAppender(context, logDir);
            for (Map.Entry<String, Level> loglevel : DEFAULT_LOG_LEVELS.entrySet()) {
                Logger logger = context.getLogger(loglevel.getKey());
                logger.setLevel(loglevel.getValue());
                logger.setAdditive(false);
                logger.addAppender(stdout);
                logger.addAppender(file);
            }
            Logger upgrades = context.getLogger("org.cryptomator.cryptofs.migration");
            upgrades.setLevel(Level.DEBUG);
            upgrades.addAppender(stdout);
            upgrades.addAppender(upgrade);
            upgrades.addAppender(file);
            upgrades.setAdditive(false);
            Logger fuseLocking = context.getLogger("org.cryptomator.frontend.fuse.locks");
            fuseLocking.setLevel(Level.OFF);
            Logger kdeWallet = context.getLogger("org.purejava.kwallet.freedesktop.dbus.handlers");
            kdeWallet.setLevel(Level.OFF);
        }
        return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
    }

    private Appender<ILoggingEvent> noopAppender(LoggerContext context) {
        NOPAppender appender = new NOPAppender();
        appender.setContext((Context)context);
        return appender;
    }

    private Appender<ILoggingEvent> stdOutAppender(LoggerContext context) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)context);
        appender.setName("STDOUT");
        appender.setEncoder((Encoder)this.encoder(context));
        appender.start();
        return appender;
    }

    private Appender<ILoggingEvent> upgradeAppender(LoggerContext context, Path logDir) {
        FileAppender appender = new FileAppender();
        appender.setContext((Context)context);
        appender.setName("UPGRADE");
        appender.setFile(logDir.resolve(UPGRADE_FILENAME).toString());
        appender.setEncoder((Encoder)this.encoder(context));
        appender.start();
        return appender;
    }

    private Appender<ILoggingEvent> fileAppender(LoggerContext context, Path logDir) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)context);
        appender.setName("FILE");
        appender.setFile(logDir.resolve(LOGFILE_NAME).toString());
        appender.setEncoder((Encoder)this.encoder(context));
        LaunchAndSizeBasedTriggeringPolicy triggeringPolicy = new LaunchAndSizeBasedTriggeringPolicy(FileSize.valueOf((String)LOG_MAX_SIZE));
        triggeringPolicy.setContext((Context)context);
        triggeringPolicy.start();
        appender.setTriggeringPolicy(triggeringPolicy);
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setFileNamePattern(logDir.resolve(LOGFILE_ROLLING_PATTERN).toString());
        rollingPolicy.setMinIndex(1);
        rollingPolicy.setMaxIndex(9);
        rollingPolicy.setParent((FileAppender)appender);
        rollingPolicy.start();
        appender.setRollingPolicy((RollingPolicy)rollingPolicy);
        appender.start();
        return appender;
    }

    private PatternLayoutEncoder encoder(LoggerContext context) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern(LOG_PATTERN);
        encoder.start();
        return encoder;
    }
}

