/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.networking;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.networking.CombinedKeyStoreSpi;
import org.cryptomator.networking.SSLContextDifferentTrustStoreBase;
import org.cryptomator.networking.SSLContextProvider;

@OperatingSystem(value=OperatingSystem.Value.MAC)
public class SSLContextWithMacKeychain
extends SSLContextDifferentTrustStoreBase
implements SSLContextProvider {
    @Override
    KeyStore getTruststore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore userKeyStore = KeyStore.getInstance("KeychainStore");
        KeyStore systemRootKeyStore = KeyStore.getInstance("KeychainStore-ROOT");
        userKeyStore.load(null);
        systemRootKeyStore.load(null);
        try {
            CombinedKeyStoreSpi spi = CombinedKeyStoreSpi.create(userKeyStore, systemRootKeyStore);
            Provider dummyProvider = new Provider("CombinedKeyStoreProvider", "1.0", "Provides a combined, read-only KeyStore"){};
            return new KeyStore(this, spi, dummyProvider, "CombinedKeyStoreProvider"){};
        }
        catch (IllegalArgumentException e) {
            throw new KeyStoreException(e);
        }
    }
}

