/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.networking;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.networking.SSLContextDifferentTrustStoreBase;
import org.cryptomator.networking.SSLContextProvider;

@OperatingSystem(value=OperatingSystem.Value.LINUX)
@CheckAvailability
public class SSLContextWithPKCS12TrustStore
extends SSLContextDifferentTrustStoreBase
implements SSLContextProvider {
    private static final String CERT_FILE_LOCATION_PROPERTY = "cryptomator.networking.truststore.p12Path";

    @Override
    KeyStore getTruststore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        Path pkcs12FilePath = Path.of(System.getProperty(CERT_FILE_LOCATION_PROPERTY), new String[0]);
        try {
            return KeyStore.getInstance(pkcs12FilePath.toFile(), new char[0]);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchFileException(pkcs12FilePath.toString());
        }
    }

    @CheckAvailability
    public static boolean isSupported() {
        String pkcs12Path = System.getProperty(CERT_FILE_LOCATION_PROPERTY);
        return Optional.ofNullable(pkcs12Path).map(x$0 -> Path.of(x$0, new String[0])).map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false);
    }
}

