/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.controls;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.cryptomator.common.Passphrase;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.cryptomator.ui.controls.SecurePasswordField;

public class NiceSecurePasswordField
extends StackPane {
    private static final String STYLE_CLASS = "nice-secure-password-field";
    private static final String ICONS_STYLE_CLASS = "icons";
    private static final String REVEAL_BUTTON_STYLE_CLASS = "reveal-button";
    private static final int ICON_SPACING = 6;
    private static final double ICON_SIZE = 14.0;
    private final SecurePasswordField passwordField = new SecurePasswordField();
    private final FontAwesome5IconView capsLockedIcon = new FontAwesome5IconView();
    private final FontAwesome5IconView nonPrintableCharsIcon = new FontAwesome5IconView();
    private final FontAwesome5IconView revealPasswordIcon = new FontAwesome5IconView();
    private final ToggleButton revealPasswordButton = new ToggleButton(null, (Node)this.revealPasswordIcon);
    private final HBox iconContainer = new HBox(6.0, new Node[]{this.nonPrintableCharsIcon, this.capsLockedIcon, this.revealPasswordButton});

    public NiceSecurePasswordField() {
        this.getStyleClass().add((Object)STYLE_CLASS);
        this.iconContainer.setAlignment(Pos.CENTER_RIGHT);
        this.iconContainer.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.iconContainer.setPrefWidth(42.0);
        this.iconContainer.getStyleClass().add((Object)ICONS_STYLE_CLASS);
        StackPane.setAlignment((Node)this.iconContainer, (Pos)Pos.CENTER_RIGHT);
        this.capsLockedIcon.setGlyph(FontAwesome5Icon.ARROW_UP);
        this.capsLockedIcon.setGlyphSize(14.0);
        this.capsLockedIcon.visibleProperty().bind((ObservableValue)this.passwordField.capsLockedProperty());
        this.capsLockedIcon.managedProperty().bind((ObservableValue)this.passwordField.capsLockedProperty());
        this.nonPrintableCharsIcon.setGlyph(FontAwesome5Icon.EXCLAMATION_TRIANGLE);
        this.nonPrintableCharsIcon.setGlyphSize(14.0);
        this.nonPrintableCharsIcon.visibleProperty().bind((ObservableValue)this.passwordField.containingNonPrintableCharsProperty());
        this.nonPrintableCharsIcon.managedProperty().bind((ObservableValue)this.passwordField.containingNonPrintableCharsProperty());
        this.revealPasswordIcon.setGlyph(FontAwesome5Icon.EYE);
        this.revealPasswordIcon.glyphProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.revealPasswordButton.selectedProperty()).then((Object)FontAwesome5Icon.EYE_SLASH).otherwise((Object)FontAwesome5Icon.EYE));
        this.revealPasswordIcon.setGlyphSize(14.0);
        this.revealPasswordButton.setContentDisplay(ContentDisplay.LEFT);
        this.revealPasswordButton.setFocusTraversable(false);
        this.revealPasswordButton.visibleProperty().bind((ObservableValue)this.passwordField.focusedProperty());
        this.revealPasswordButton.managedProperty().bind((ObservableValue)this.passwordField.focusedProperty());
        this.revealPasswordButton.getStyleClass().add((Object)REVEAL_BUTTON_STYLE_CLASS);
        this.passwordField.revealPasswordProperty().bind((ObservableValue)this.revealPasswordButton.selectedProperty());
        this.getChildren().addAll((Object[])new Node[]{this.passwordField, this.iconContainer});
        this.disabledProperty().addListener(this::disabledChanged);
    }

    private void disabledChanged(Observable observable) {
        this.revealPasswordButton.setSelected(false);
    }

    public void requestFocus() {
        this.passwordField.requestFocus();
    }

    public String getText() {
        return this.passwordField.getText();
    }

    public StringProperty textProperty() {
        return this.passwordField.textProperty();
    }

    public Passphrase getCharacters() {
        return this.passwordField.getCharacters();
    }

    public void setPassword(CharSequence password) {
        this.passwordField.setPassword(password);
    }

    public void setPassword(char[] password) {
        this.passwordField.setPassword(password);
    }

    public void wipe() {
        this.passwordField.wipe();
    }

    public void selectAll() {
        this.passwordField.selectAll();
    }

    public void selectRange(int anchor, int caretPosition) {
        this.passwordField.selectRange(anchor, caretPosition);
    }
}

