/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.controls;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class NotificationBar
extends HBox {
    @FXML
    private Label notificationLabel;
    private final BooleanProperty dismissable = new SimpleBooleanProperty();
    private final BooleanProperty notify = new SimpleBooleanProperty();

    public NotificationBar() {
        this.setAlignment(Pos.CENTER);
        this.setStyle("-fx-alignment: center;");
        Region spacer = new Region();
        spacer.setMinWidth(40.0);
        Region leftRegion = new Region();
        HBox.setHgrow((Node)leftRegion, (Priority)Priority.ALWAYS);
        Region rightRegion = new Region();
        HBox.setHgrow((Node)rightRegion, (Priority)Priority.ALWAYS);
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)vbox, (Priority)Priority.ALWAYS);
        this.notificationLabel = new Label();
        this.notificationLabel.getStyleClass().add((Object)"notification-label");
        this.notificationLabel.setStyle("-fx-alignment: center;");
        vbox.getChildren().add((Object)this.notificationLabel);
        Button closeButton = new Button("X");
        closeButton.setMinWidth(40.0);
        closeButton.setStyle("-fx-background-color: transparent; -fx-text-fill: white; -fx-font-weight: bold;");
        closeButton.visibleProperty().bind((ObservableValue)this.dismissable);
        closeButton.setOnAction(actionEvent -> {
            this.visibleProperty().unbind();
            this.managedProperty().unbind();
            this.visibleProperty().set(false);
            this.managedProperty().set(false);
        });
        closeButton.visibleProperty().bind((ObservableValue)this.dismissable);
        this.getChildren().addAll((Object[])new Node[]{spacer, leftRegion, vbox, rightRegion, closeButton});
        this.visibleProperty().bind((ObservableValue)this.notifyProperty());
        this.managedProperty().bind((ObservableValue)this.notifyProperty());
    }

    public String getText() {
        return this.notificationLabel.getText();
    }

    public void setText(String text) {
        this.notificationLabel.setText(text);
    }

    public void setStyleClass(String styleClass) {
        this.getStyleClass().clear();
        this.getStyleClass().add((Object)styleClass);
    }

    public boolean isDismissable() {
        return this.dismissable.get();
    }

    public void setDismissable(boolean value) {
        this.dismissable.set(value);
    }

    public boolean getNotify() {
        return this.notify.get();
    }

    public void setNotify(boolean value) {
        this.notify.set(value);
    }

    public BooleanProperty notifyProperty() {
        return this.notify;
    }
}

