/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.decryptname;

import dagger.BindsInstance;
import dagger.Lazy;
import dagger.Subcomponent;
import java.nio.file.Path;
import java.util.List;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.decryptname.DecryptNameModule;
import org.cryptomator.ui.decryptname.DecryptNameScoped;
import org.cryptomator.ui.decryptname.DecryptNameWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DecryptNameScoped
@Subcomponent(modules={DecryptNameModule.class})
public interface DecryptNameComponent {
    public static final Logger LOG = LoggerFactory.getLogger(DecryptNameComponent.class);

    @DecryptNameWindow
    public Stage window();

    @FxmlScene(value=FxmlFile.DECRYPTNAMES)
    public Lazy<Scene> decryptNamesView();

    @DecryptNameWindow
    public Vault vault();

    default public void showDecryptFileNameWindow() {
        Stage s = this.window();
        s.setScene((Scene)this.decryptNamesView().get());
        s.sizeToScene();
        if (this.vault().isUnlocked()) {
            s.show();
        } else {
            LOG.error("Aborted showing DecryptFileName window: vault state is not {}, but {}.", (Object)VaultState.Value.UNLOCKED, (Object)this.vault().getState());
        }
    }

    @Subcomponent.Factory
    public static interface Factory {
        public DecryptNameComponent create(@BindsInstance @DecryptNameWindow Vault var1, @BindsInstance @Named(value="windowOwner") Stage var2, @BindsInstance @DecryptNameWindow List<Path> var3);
    }
}

