/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.decryptname;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.decryptname.DecryptFileNamesViewController;
import org.cryptomator.ui.decryptname.DecryptNameScoped;
import org.cryptomator.ui.decryptname.DecryptNameWindow;

@Module
public abstract class DecryptNameModule {
    @Provides
    @DecryptNameScoped
    @DecryptNameWindow
    static Stage provideStage(StageFactory factory, @Named(value="windowOwner") Stage owner, @DecryptNameWindow Vault vault, ResourceBundle resourceBundle) {
        Stage stage = factory.create();
        stage.setResizable(true);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)owner);
        stage.setTitle(resourceBundle.getString("decryptNames.title"));
        vault.stateProperty().addListener((observableValue, value, value2) -> stage.close());
        return stage;
    }

    @Provides
    @DecryptNameScoped
    @DecryptNameWindow
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @FxmlScene(value=FxmlFile.DECRYPTNAMES)
    @DecryptNameScoped
    static Scene provideDecryptNamesViewScene(@DecryptNameWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.DECRYPTNAMES);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=DecryptFileNamesViewController.class)
    abstract FxController bindDecryptNamesViewController(DecryptFileNamesViewController var1);
}

