/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.dialogs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.IllegalFormatException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.dialogs.SimpleDialogController;

public class SimpleDialog {
    private final ResourceBundle resourceBundle;
    private final Stage dialogStage;

    SimpleDialog(Builder builder) throws IOException {
        this.resourceBundle = builder.resourceBundle;
        this.dialogStage = builder.stageFactory.create();
        this.dialogStage.initOwner((Window)builder.owner);
        this.dialogStage.initModality(Modality.WINDOW_MODAL);
        this.dialogStage.setTitle(this.resolveText(builder.titleKey, builder.titleArgs));
        this.dialogStage.setResizable(false);
        FxmlLoaderFactory loaderFactory = FxmlLoaderFactory.forController(new SimpleDialogController(this.resolveText(builder.messageKey, null), this.resolveText(builder.descriptionKey, builder.descriptionArgs), builder.icon, this.resolveText(builder.okButtonKey, null), builder.cancelButtonKey != null ? this.resolveText(builder.cancelButtonKey, null) : null, () -> builder.okAction.accept(this.dialogStage), () -> builder.cancelAction.accept(this.dialogStage)), builder.sceneFactory, builder.resourceBundle);
        this.dialogStage.setScene(loaderFactory.createScene(FxmlFile.SIMPLE_DIALOG));
    }

    public void showAndWait() {
        this.dialogStage.showAndWait();
    }

    private String resolveText(String key, String[] args) {
        if (key == null || key.isEmpty() || !this.resourceBundle.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Invalid key: '%s'. Key not found in ResourceBundle.", key));
        }
        String text = this.resourceBundle.getString(key);
        try {
            return args != null && args.length > 0 ? String.format(text, args) : text;
        }
        catch (IllegalFormatException e) {
            throw new IllegalArgumentException("Formatting error: Check if arguments match placeholders in the text.", e);
        }
    }

    public static class Builder {
        private Stage owner;
        private final ResourceBundle resourceBundle;
        private final StageFactory stageFactory;
        private final DefaultSceneFactory sceneFactory;
        private String titleKey;
        private String[] titleArgs;
        private String messageKey;
        private String descriptionKey;
        private String[] descriptionArgs;
        private String okButtonKey;
        private String cancelButtonKey;
        private FontAwesome5Icon icon;
        private Consumer<Stage> okAction = Stage::close;
        private Consumer<Stage> cancelAction = Stage::close;

        public Builder(ResourceBundle resourceBundle, StageFactory stageFactory, DefaultSceneFactory sceneFactory) {
            this.resourceBundle = resourceBundle;
            this.stageFactory = stageFactory;
            this.sceneFactory = sceneFactory;
        }

        public Builder setOwner(Stage owner) {
            this.owner = owner;
            return this;
        }

        public Builder setTitleKey(String titleKey, String ... args) {
            this.titleKey = titleKey;
            this.titleArgs = args;
            return this;
        }

        public Builder setMessageKey(String messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public Builder setDescriptionKey(String descriptionKey, String ... args) {
            this.descriptionKey = descriptionKey;
            this.descriptionArgs = args;
            return this;
        }

        public Builder setIcon(FontAwesome5Icon icon) {
            this.icon = icon;
            return this;
        }

        public Builder setOkButtonKey(String okButtonKey) {
            this.okButtonKey = okButtonKey;
            return this;
        }

        public Builder setCancelButtonKey(String cancelButtonKey) {
            this.cancelButtonKey = cancelButtonKey;
            return this;
        }

        public Builder setOkAction(Consumer<Stage> okAction) {
            this.okAction = okAction;
            return this;
        }

        public Builder setCancelAction(Consumer<Stage> cancelAction) {
            this.cancelAction = cancelAction;
            return this;
        }

        public SimpleDialog build() {
            Objects.requireNonNull(this.titleKey, "SimpleDialog titleKey must be set.");
            Objects.requireNonNull(this.messageKey, "SimpleDialog messageKey must be set.");
            Objects.requireNonNull(this.descriptionKey, "SimpleDialog descriptionKey must be set.");
            Objects.requireNonNull(this.okButtonKey, "SimpleDialog okButtonKey must be set.");
            try {
                return new SimpleDialog(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create SimpleDialog.", e);
            }
        }
    }
}

