/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.eventview;

import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.event.FSEventBucket;
import org.cryptomator.event.FSEventBucketContent;
import org.cryptomator.event.FileSystemEventAggregator;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.eventview.EventListCellFactory;
import org.cryptomator.ui.eventview.EventViewScoped;
import org.cryptomator.ui.fxapp.FxFSEventList;

@EventViewScoped
public class EventViewController
implements FxController {
    private final FilteredList<Map.Entry<FSEventBucket, FSEventBucketContent>> filteredEventList;
    private final ObservableList<Vault> vaults;
    private final FileSystemEventAggregator aggregator;
    private final SortedList<Map.Entry<FSEventBucket, FSEventBucketContent>> sortedEventList;
    private final ObservableList<Vault> choiceBoxEntries;
    private final ResourceBundle resourceBundle;
    private final EventListCellFactory cellFactory;
    @FXML
    ChoiceBox<Vault> vaultFilterChoiceBox;
    @FXML
    ListView<Map.Entry<FSEventBucket, FSEventBucketContent>> eventListView;

    @Inject
    public EventViewController(FxFSEventList fxFSEventList, ObservableList<Vault> vaults, ResourceBundle resourceBundle, EventListCellFactory cellFactory, FileSystemEventAggregator aggregator) {
        this.filteredEventList = fxFSEventList.getObservableList().filtered(entry -> true);
        this.vaults = vaults;
        this.aggregator = aggregator;
        this.sortedEventList = new SortedList(this.filteredEventList, this::compareBuckets);
        this.choiceBoxEntries = FXCollections.observableArrayList();
        this.resourceBundle = resourceBundle;
        this.cellFactory = cellFactory;
    }

    private int compareBuckets(Map.Entry<FSEventBucket, FSEventBucketContent> left, Map.Entry<FSEventBucket, FSEventBucketContent> right) {
        Instant t2;
        Instant t1 = left.getValue().mostRecentEvent().getTimestamp();
        int timeComparison = t1.compareTo(t2 = right.getValue().mostRecentEvent().getTimestamp());
        if (timeComparison != 0) {
            return -timeComparison;
        }
        int vaultIdComparison = left.getKey().vault().getId().compareTo(right.getKey().vault().getId());
        if (vaultIdComparison != 0) {
            return vaultIdComparison;
        }
        int pathComparison = left.getKey().idPath().compareTo(right.getKey().idPath());
        if (pathComparison != 0) {
            return pathComparison;
        }
        return left.getKey().c().getName().compareTo(right.getKey().c().getName());
    }

    @FXML
    public void initialize() {
        this.choiceBoxEntries.add(null);
        this.choiceBoxEntries.addAll(this.vaults);
        this.vaults.addListener(c -> {
            while (c.next()) {
                this.choiceBoxEntries.removeAll((Collection)c.getRemoved());
                this.choiceBoxEntries.addAll((Collection)c.getAddedSubList());
            }
        });
        this.eventListView.setCellFactory((Callback)this.cellFactory);
        this.eventListView.setItems(this.sortedEventList);
        this.vaultFilterChoiceBox.setItems(this.choiceBoxEntries);
        this.vaultFilterChoiceBox.valueProperty().addListener(this::applyVaultFilter);
        this.vaultFilterChoiceBox.setConverter((StringConverter)new VaultConverter(this.resourceBundle));
    }

    private void applyVaultFilter(ObservableValue<? extends Vault> v, Vault oldV, Vault newV) {
        if (newV == null) {
            this.filteredEventList.setPredicate(entry -> true);
        } else {
            this.filteredEventList.setPredicate(e -> ((FSEventBucket)e.getKey()).vault().equals(newV));
        }
    }

    @FXML
    void clearEvents() {
        this.aggregator.clear();
    }

    private static class VaultConverter
    extends StringConverter<Vault> {
        private final ResourceBundle resourceBundle;

        VaultConverter(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public String toString(Vault v) {
            if (v == null) {
                return this.resourceBundle.getString("eventView.filter.allVaults");
            }
            return v.getDisplayName();
        }

        public Vault fromString(String displayLanguage) {
            throw new UnsupportedOperationException();
        }
    }
}

