/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.forgetpassword;

import javafx.beans.property.BooleanProperty;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.forgetpassword.ForgetPasswordScoped;
import org.cryptomator.ui.forgetpassword.ForgetPasswordWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ForgetPasswordScoped
public class ForgetPasswordController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ForgetPasswordController.class);
    private final Stage window;
    private final Vault vault;
    private final KeychainManager keychain;
    private final BooleanProperty confirmedResult;

    @Inject
    public ForgetPasswordController(@ForgetPasswordWindow Stage window, @ForgetPasswordWindow Vault vault, KeychainManager keychain, @ForgetPasswordWindow BooleanProperty confirmedResult) {
        this.window = window;
        this.vault = vault;
        this.keychain = keychain;
        this.confirmedResult = confirmedResult;
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void finish() {
        if (this.keychain.isSupported()) {
            try {
                this.keychain.deletePassphrase(this.vault.getId());
                LOG.debug("Forgot password for vault {}.", (Object)this.vault.getDisplayName());
                this.confirmedResult.setValue(Boolean.valueOf(true));
            }
            catch (KeychainAccessException e) {
                LOG.error("Failed to delete passphrase from system keychain.", (Throwable)e);
                this.confirmedResult.setValue(Boolean.valueOf(false));
            }
        } else {
            LOG.warn("Keychain not supported. Doing nothing.");
        }
        this.window.close();
    }
}

