/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.cryptomator.event.FSEventBucket;
import org.cryptomator.event.FSEventBucketContent;
import org.cryptomator.event.FileSystemEventAggregator;
import org.cryptomator.ui.fxapp.FxApplicationScoped;

@FxApplicationScoped
public class FxFSEventList {
    private final ObservableList<Map.Entry<FSEventBucket, FSEventBucketContent>> events = FXCollections.observableArrayList();
    private final FileSystemEventAggregator eventAggregator;
    private final ScheduledExecutorService scheduler;
    private final BooleanProperty unreadEvents;

    @Inject
    public FxFSEventList(FileSystemEventAggregator fsEventAggregator, ScheduledExecutorService scheduler) {
        this.eventAggregator = fsEventAggregator;
        this.scheduler = scheduler;
        this.unreadEvents = new SimpleBooleanProperty(false);
    }

    public void schedulePollForUpdates() {
        this.scheduler.schedule(this::checkForEventUpdates, 1000L, TimeUnit.MILLISECONDS);
    }

    private void checkForEventUpdates() {
        if (this.eventAggregator.hasMaybeUpdates()) {
            Platform.runLater(() -> {
                this.eventAggregator.cloneTo((Collection<Map.Entry<FSEventBucket, FSEventBucketContent>>)this.events);
                this.unreadEvents.setValue(Boolean.valueOf(true));
                this.schedulePollForUpdates();
            });
        } else {
            this.schedulePollForUpdates();
        }
    }

    public ObservableList<Map.Entry<FSEventBucket, FSEventBucketContent>> getObservableList() {
        return this.events;
    }

    public BooleanProperty unreadEventsProperty() {
        return this.unreadEvents;
    }
}

