/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import java.time.Instant;
import java.util.Comparator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.common.SemVerComparator;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class UpdateChecker {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChecker.class);
    private static final Duration AUTO_CHECK_DELAY = Duration.seconds((double)5.0);
    private final Environment env;
    private final Settings settings;
    private final StringProperty latestVersion = new SimpleStringProperty();
    private final ScheduledService<String> updateCheckerService;
    private final ObjectProperty<UpdateCheckState> state = new SimpleObjectProperty((Object)UpdateCheckState.NOT_CHECKED);
    private final ObjectProperty<Instant> lastSuccessfulUpdateCheck;
    private final Comparator<String> versionComparator = new SemVerComparator();
    private final BooleanBinding updateAvailable;
    private final BooleanBinding checkFailed;

    @Inject
    UpdateChecker(Settings settings, Environment env, ScheduledService<String> updateCheckerService) {
        this.env = env;
        this.settings = settings;
        this.updateCheckerService = updateCheckerService;
        this.lastSuccessfulUpdateCheck = settings.lastSuccessfulUpdateCheck;
        this.updateAvailable = Bindings.createBooleanBinding(this::isUpdateAvailable, (Observable[])new Observable[]{this.latestVersion});
        this.checkFailed = Bindings.equal((Object)((Object)UpdateCheckState.CHECK_FAILED), this.state);
    }

    public void automaticallyCheckForUpdatesIfEnabled() {
        if (!this.env.disableUpdateCheck() && this.settings.checkForUpdates.get()) {
            this.startCheckingForUpdates(AUTO_CHECK_DELAY);
        }
    }

    public void checkForUpdatesNow() {
        this.startCheckingForUpdates(Duration.ZERO);
    }

    private void startCheckingForUpdates(Duration initialDelay) {
        this.updateCheckerService.cancel();
        this.updateCheckerService.reset();
        this.updateCheckerService.setDelay(initialDelay);
        this.updateCheckerService.setOnRunning(this::checkStarted);
        this.updateCheckerService.setOnSucceeded(this::checkSucceeded);
        this.updateCheckerService.setOnFailed(this::checkFailed);
        this.updateCheckerService.start();
    }

    private void checkStarted(WorkerStateEvent event) {
        LOG.debug("Checking for updates...");
        this.state.set((Object)UpdateCheckState.IS_CHECKING);
    }

    private void checkSucceeded(WorkerStateEvent event) {
        String latestVersionString = (String)this.updateCheckerService.getValue();
        LOG.info("Current version: {}, latest version: {}", (Object)this.getCurrentVersion(), (Object)latestVersionString);
        this.lastSuccessfulUpdateCheck.set((Object)Instant.now());
        this.latestVersion.set((Object)latestVersionString);
        this.state.set((Object)UpdateCheckState.CHECK_SUCCESSFUL);
    }

    private void checkFailed(WorkerStateEvent event) {
        this.state.set((Object)UpdateCheckState.CHECK_FAILED);
    }

    public BooleanBinding checkingForUpdatesProperty() {
        return this.updateCheckerService.stateProperty().isEqualTo((Object)Worker.State.RUNNING);
    }

    public ReadOnlyStringProperty latestVersionProperty() {
        return this.latestVersion;
    }

    public BooleanBinding updateAvailableProperty() {
        return this.updateAvailable;
    }

    public BooleanBinding checkFailedProperty() {
        return this.checkFailed;
    }

    public boolean isUpdateAvailable() {
        String currentVersion = this.getCurrentVersion();
        String latestVersionString = (String)this.latestVersion.get();
        if (currentVersion == null || latestVersionString == null) {
            return false;
        }
        return this.versionComparator.compare(currentVersion, latestVersionString) < 0;
    }

    public ObjectProperty<Instant> lastSuccessfulUpdateCheckProperty() {
        return this.lastSuccessfulUpdateCheck;
    }

    public ObjectProperty<UpdateCheckState> updateCheckStateProperty() {
        return this.state;
    }

    public String getCurrentVersion() {
        return this.env.getAppVersion();
    }

    public static enum UpdateCheckState {
        NOT_CHECKED,
        IS_CHECKING,
        CHECK_SUCCESSFUL,
        CHECK_FAILED;

    }
}

