/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import dagger.Module;
import dagger.Provides;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.util.Duration;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.UpdateCheckerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module
public abstract class UpdateCheckerModule {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCheckerModule.class);
    private static final URI LATEST_VERSION_URI = URI.create("https://api.cryptomator.org/desktop/latest-version.json");
    private static final Duration UPDATE_CHECK_INTERVAL = Duration.hours((double)3.0);
    private static final Duration DISABLED_UPDATE_CHECK_INTERVAL = Duration.hours((double)100000.0);

    @Provides
    @FxApplicationScoped
    static Optional<HttpClient> provideHttpClient() {
        try {
            return Optional.of(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build());
        }
        catch (UncheckedIOException e) {
            LOG.error("HttpClient for update check cannot be created.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Provides
    @FxApplicationScoped
    static HttpRequest provideCheckForUpdatesRequest(Environment env) {
        String userAgent = String.format("Cryptomator VersionChecker/%s %s %s (%s)", env.getAppVersion(), SystemUtils.OS_NAME, SystemUtils.OS_VERSION, SystemUtils.OS_ARCH);
        return HttpRequest.newBuilder().uri(LATEST_VERSION_URI).header("User-Agent", userAgent).timeout(java.time.Duration.ofSeconds(10L)).build();
    }

    @Provides
    @Named(value="checkForUpdatesInterval")
    @FxApplicationScoped
    static ObjectBinding<Duration> provideCheckForUpdateInterval(Settings settings) {
        return Bindings.when((ObservableBooleanValue)settings.checkForUpdates).then((Object)UPDATE_CHECK_INTERVAL).otherwise((Object)DISABLED_UPDATE_CHECK_INTERVAL);
    }

    @Provides
    @FxApplicationScoped
    static ScheduledService<String> provideCheckForUpdatesService(ExecutorService executor, final Optional<HttpClient> httpClient, final HttpRequest checkForUpdatesRequest, @Named(value="checkForUpdatesInterval") ObjectBinding<Duration> period) {
        ScheduledService<String> service = new ScheduledService<String>(){

            protected Task<String> createTask() {
                if (httpClient.isPresent()) {
                    return new UpdateCheckerTask((HttpClient)httpClient.get(), checkForUpdatesRequest);
                }
                return new Task<String>(this){

                    protected String call() {
                        throw new NullPointerException("No HttpClient present.");
                    }
                };
            }
        };
        service.setOnFailed(arg_0 -> UpdateCheckerModule.lambda$provideCheckForUpdatesService$0((ScheduledService)service, arg_0));
        service.setExecutor((Executor)executor);
        service.periodProperty().bind(period);
        return service;
    }

    private static /* synthetic */ void lambda$provideCheckForUpdatesService$0(ScheduledService service, WorkerStateEvent event) {
        LOG.error("Failed to execute update service", service.getException());
    }
}

