/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import javafx.concurrent.Task;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCheckerTask
extends Task<String> {
    private static final ObjectMapper JSON = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(UpdateCheckerTask.class);
    private static final long MAX_RESPONSE_SIZE = 10240L;
    private final HttpClient httpClient;
    private final HttpRequest checkForUpdatesRequest;

    UpdateCheckerTask(HttpClient httpClient, HttpRequest checkForUpdatesRequest) {
        this.httpClient = httpClient;
        this.checkForUpdatesRequest = checkForUpdatesRequest;
        this.setOnFailed(event -> LOG.error("Failed to check for updates", this.getException()));
    }

    protected String call() throws IOException, InterruptedException {
        HttpResponse<InputStream> response = this.httpClient.send(this.checkForUpdatesRequest, HttpResponse.BodyHandlers.ofInputStream());
        if (response.statusCode() == 200) {
            return this.processBody(response);
        }
        throw new IOException("Unexpected HTTP response code " + response.statusCode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processBody(HttpResponse<InputStream> response) throws IOException {
        try (InputStream in = response.body();
             InputStream limitedIn = ByteStreams.limit((InputStream)in, (long)10240L);){
            JsonNode json = JSON.reader().readTree(limitedIn);
            if (SystemUtils.IS_OS_MAC_OSX) {
                String string = json.get("mac").asText();
                return string;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                String string = json.get("win").asText();
                return string;
            }
            if (!SystemUtils.IS_OS_LINUX) throw new IllegalStateException("Unsupported operating system");
            String string = json.get("linux").asText();
            return string;
        }
    }
}

