/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyObservableList;
import com.tobiasdiez.easybind.Subscription;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ListView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.health.Check;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.Result;
import org.cryptomator.ui.health.ResultFixApplier;
import org.cryptomator.ui.health.ResultListCellFactory;

@HealthCheckScoped
public class CheckDetailController
implements FxController {
    private final EasyObservableList<Result> results;
    private final ObjectProperty<Check> check;
    private final ObservableValue<Check.CheckState> checkState;
    private final ObservableValue<String> checkName;
    private final BooleanExpression checkRunning;
    private final BooleanExpression checkScheduled;
    private final BooleanExpression checkFinished;
    private final BooleanExpression checkSkipped;
    private final BooleanExpression checkSucceeded;
    private final BooleanExpression checkFailed;
    private final BooleanExpression checkCancelled;
    private final Binding<Number> countOfWarnSeverity;
    private final Binding<Number> countOfCritSeverity;
    private final Binding<Boolean> warnOrCritsExist;
    private final ResultListCellFactory resultListCellFactory;
    private final ResultFixApplier resultFixApplier;
    private final ResourceBundle resourceBundle;
    private final BooleanProperty fixAllInfoResultsExecuted;
    private final BooleanBinding fixAllInfoResultsPossible;
    private final ObjectProperty<Predicate<Result>> resultsFilter;
    public ListView<Result> resultsListView;
    public ChoiceBox<DiagnosticResult.Severity> severityChoiceBox;
    public ChoiceBox<Result.FixState> fixStateChoiceBox;
    private Subscription resultSubscription;

    @Inject
    public CheckDetailController(ObjectProperty<Check> selectedTask, ResultListCellFactory resultListCellFactory, ResultFixApplier resultFixApplier, ResourceBundle resourceBundle) {
        this.resultListCellFactory = resultListCellFactory;
        this.resultFixApplier = resultFixApplier;
        this.resourceBundle = resourceBundle;
        this.results = EasyBind.wrapList((ObservableList)FXCollections.observableArrayList());
        this.check = selectedTask;
        this.checkState = selectedTask.flatMap(Check::stateProperty);
        this.checkName = selectedTask.map(Check::getName).orElse((Object)"");
        this.checkRunning = BooleanExpression.booleanExpression((ObservableValue)this.checkState.map(Check.CheckState.RUNNING::equals).orElse((Object)false));
        this.checkScheduled = BooleanExpression.booleanExpression((ObservableValue)this.checkState.map(Check.CheckState.SCHEDULED::equals).orElse((Object)false));
        this.checkSkipped = BooleanExpression.booleanExpression((ObservableValue)this.checkState.map(Check.CheckState.SKIPPED::equals).orElse((Object)false));
        this.checkSucceeded = BooleanExpression.booleanExpression((ObservableValue)this.checkState.map(Check.CheckState.SUCCEEDED::equals).orElse((Object)false));
        this.checkFailed = BooleanExpression.booleanExpression((ObservableValue)this.checkState.map(Check.CheckState.ERROR::equals).orElse((Object)false));
        this.checkCancelled = BooleanExpression.booleanExpression((ObservableValue)this.checkState.map(Check.CheckState.CANCELLED::equals).orElse((Object)false));
        this.checkFinished = this.checkSucceeded.or((ObservableBooleanValue)this.checkFailed).or((ObservableBooleanValue)this.checkCancelled);
        this.countOfWarnSeverity = this.results.reduce(this.countSeverity(DiagnosticResult.Severity.WARN));
        this.countOfCritSeverity = this.results.reduce(this.countSeverity(DiagnosticResult.Severity.CRITICAL));
        this.warnOrCritsExist = EasyBind.combine((ObservableValue)this.checkSucceeded, this.countOfWarnSeverity, this.countOfCritSeverity, (suceeded, warns, crits) -> suceeded != false && (warns.longValue() > 0L || crits.longValue() > 0L));
        this.fixAllInfoResultsExecuted = new SimpleBooleanProperty(false);
        this.fixAllInfoResultsPossible = Bindings.createBooleanBinding(() -> this.results.stream().anyMatch(this::isFixableInfoResult), (Observable[])new Observable[]{this.results}).and((ObservableBooleanValue)this.fixAllInfoResultsExecuted.not());
        this.resultsFilter = new SimpleObjectProperty(r -> true);
        selectedTask.addListener(this::selectedTaskChanged);
    }

    private boolean isFixableInfoResult(Result r) {
        return r.diagnosis().getSeverity() == DiagnosticResult.Severity.INFO && r.getState() == Result.FixState.FIXABLE;
    }

    private void selectedTaskChanged(ObservableValue<? extends Check> observable, Check oldValue, Check newValue) {
        if (this.resultSubscription != null) {
            this.resultSubscription.unsubscribe();
        }
        if (newValue != null) {
            this.resultSubscription = EasyBind.bindContent(this.results, newValue.getResults());
        }
        this.severityChoiceBox.setValue(null);
        this.fixStateChoiceBox.setValue(null);
    }

    private Function<Stream<? extends Result>, Long> countSeverity(DiagnosticResult.Severity severity) {
        return stream -> stream.filter(item -> severity.equals((Object)item.diagnosis().getSeverity())).count();
    }

    @FXML
    public void initialize() {
        this.resultsListView.setItems((ObservableList)this.results.filtered(this.resultsFilter));
        this.resultsListView.setCellFactory((Callback)this.resultListCellFactory);
        this.severityChoiceBox.getItems().add(null);
        this.severityChoiceBox.getItems().addAll(Arrays.stream(DiagnosticResult.Severity.values()).toList());
        this.severityChoiceBox.setConverter((StringConverter)new SeverityStringifier());
        this.severityChoiceBox.setValue(null);
        this.fixStateChoiceBox.getItems().add(null);
        this.fixStateChoiceBox.getItems().addAll(Arrays.stream(Result.FixState.values()).toList());
        this.fixStateChoiceBox.setConverter((StringConverter)new FixStateStringifier());
        this.fixStateChoiceBox.setValue(null);
        this.resultsFilter.bind((ObservableValue)Bindings.createObjectBinding(() -> this::filterResults, (Observable[])new Observable[]{this.severityChoiceBox.valueProperty(), this.fixStateChoiceBox.valueProperty()}));
    }

    private boolean filterResults(Result r) {
        Result.FixState desiredFixState = (Result.FixState)((Object)this.fixStateChoiceBox.getValue());
        DiagnosticResult.Severity desiredSeverity = (DiagnosticResult.Severity)this.severityChoiceBox.getValue();
        return !(desiredFixState != null && r.getState() != desiredFixState || desiredSeverity != null && r.diagnosis().getSeverity() != desiredSeverity);
    }

    @FXML
    public void fixAllInfoResults() {
        this.fixAllInfoResultsExecuted.setValue(Boolean.valueOf(true));
        this.results.stream().filter(this::isFixableInfoResult).forEach(this.resultFixApplier::fix);
    }

    @FXML
    public void copyResultDetails() {
        Result result = (Result)this.resultsListView.getSelectionModel().getSelectedItem();
        if (result != null) {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(result.diagnosis().toString());
            Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
        }
    }

    public String getCheckName() {
        return (String)this.checkName.getValue();
    }

    public ObservableValue<String> checkNameProperty() {
        return this.checkName;
    }

    public long getCountOfWarnSeverity() {
        return ((Number)this.countOfWarnSeverity.getValue()).longValue();
    }

    public Binding<Number> countOfWarnSeverityProperty() {
        return this.countOfWarnSeverity;
    }

    public long getCountOfCritSeverity() {
        return ((Number)this.countOfCritSeverity.getValue()).longValue();
    }

    public Binding<Number> countOfCritSeverityProperty() {
        return this.countOfCritSeverity;
    }

    public boolean isCheckRunning() {
        return this.checkRunning.getValue();
    }

    public BooleanExpression checkRunningProperty() {
        return this.checkRunning;
    }

    public boolean isCheckFinished() {
        return this.checkFinished.getValue();
    }

    public BooleanExpression checkFinishedProperty() {
        return this.checkFinished;
    }

    public boolean isCheckScheduled() {
        return this.checkScheduled.getValue();
    }

    public BooleanExpression checkScheduledProperty() {
        return this.checkScheduled;
    }

    public boolean isCheckSkipped() {
        return this.checkSkipped.getValue();
    }

    public BooleanExpression checkSkippedProperty() {
        return this.checkSkipped;
    }

    public boolean isCheckSucceeded() {
        return this.checkSucceeded.getValue();
    }

    public BooleanExpression checkSucceededProperty() {
        return this.checkSucceeded;
    }

    public boolean isCheckFailed() {
        return this.checkFailed.getValue();
    }

    public BooleanExpression checkFailedProperty() {
        return this.checkFailed;
    }

    public boolean isCheckCancelled() {
        return this.checkCancelled.getValue();
    }

    public Binding<Boolean> warnOrCritsExistProperty() {
        return this.warnOrCritsExist;
    }

    public boolean isWarnOrCritsExist() {
        return (Boolean)this.warnOrCritsExist.getValue();
    }

    public BooleanExpression checkCancelledProperty() {
        return this.checkCancelled;
    }

    public ObjectProperty<Check> checkProperty() {
        return this.check;
    }

    public Check getCheck() {
        return (Check)this.check.get();
    }

    public ObservableValue<Boolean> fixAllInfoResultsPossibleProperty() {
        return this.fixAllInfoResultsPossible;
    }

    public boolean getFixAllInfoResultsPossible() {
        return this.fixAllInfoResultsPossible.getValue();
    }

    class SeverityStringifier
    extends StringConverter<DiagnosticResult.Severity> {
        SeverityStringifier() {
        }

        public String toString(DiagnosticResult.Severity object) {
            if (object == null) {
                return CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.all");
            }
            return switch (object) {
                default -> throw new MatchException(null, null);
                case DiagnosticResult.Severity.GOOD -> CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.good");
                case DiagnosticResult.Severity.INFO -> CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.info");
                case DiagnosticResult.Severity.WARN -> CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.warn");
                case DiagnosticResult.Severity.CRITICAL -> CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.crit");
            };
        }

        public DiagnosticResult.Severity fromString(String string) {
            if (CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.good").equals(string)) {
                return DiagnosticResult.Severity.GOOD;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.info").equals(string)) {
                return DiagnosticResult.Severity.INFO;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.warn").equals(string)) {
                return DiagnosticResult.Severity.WARN;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.severityFilter.crit").equals(string)) {
                return DiagnosticResult.Severity.CRITICAL;
            }
            return null;
        }
    }

    class FixStateStringifier
    extends StringConverter<Result.FixState> {
        FixStateStringifier() {
        }

        public String toString(Result.FixState object) {
            if (object == null) {
                return CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.all");
            }
            return switch (object) {
                default -> throw new MatchException(null, null);
                case Result.FixState.FIXABLE -> CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixable");
                case Result.FixState.NOT_FIXABLE -> CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.notFixable");
                case Result.FixState.FIXING -> CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixing");
                case Result.FixState.FIXED -> CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixed");
                case Result.FixState.FIX_FAILED -> CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixFailed");
            };
        }

        public Result.FixState fromString(String string) {
            if (CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixable").equals(string)) {
                return Result.FixState.FIXABLE;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.notFixable").equals(string)) {
                return Result.FixState.NOT_FIXABLE;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixing").equals(string)) {
                return Result.FixState.FIXING;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixed").equals(string)) {
                return Result.FixState.FIXED;
            }
            if (CheckDetailController.this.resourceBundle.getString("health.result.fixStateFilter.fixFailed").equals(string)) {
                return Result.FixState.FIX_FAILED;
            }
            return null;
        }
    }
}

