/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.HealthCheckWindow;
import org.cryptomator.ui.health.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckScoped
class ResultFixApplier {
    private static final Logger LOG = LoggerFactory.getLogger(ResultFixApplier.class);
    private final Path vaultPath;
    private final SecureRandom csprng;
    private final Masterkey masterkey;
    private final VaultConfig vaultConfig;
    private final ExecutorService sequentialExecutor;

    @Inject
    public ResultFixApplier(@HealthCheckWindow Vault vault, AtomicReference<Masterkey> masterkeyRef, AtomicReference<VaultConfig> vaultConfigRef, SecureRandom csprng) {
        this.vaultPath = vault.getPath();
        this.masterkey = masterkeyRef.get();
        this.vaultConfig = vaultConfigRef.get();
        this.csprng = csprng;
        this.sequentialExecutor = Executors.newSingleThreadExecutor();
    }

    public CompletionStage<Void> fix(Result result) {
        Preconditions.checkArgument((result.getState() == Result.FixState.FIXABLE ? 1 : 0) != 0);
        return ((CompletableFuture)CompletableFuture.runAsync(() -> result.setState(Result.FixState.FIXING), Platform::runLater).thenRunAsync(() -> this.fix(result.diagnosis()), this.sequentialExecutor)).whenCompleteAsync((unused, throwable) -> {
            Result.FixState s;
            if (throwable == null) {
                LOG.debug("Fix for {} applied successful.", (Object)result.diagnosis().getClass().getName());
                s = Result.FixState.FIXED;
            } else {
                LOG.error("Failed to apply fix for {}", (Object)result.diagnosis().getClass().getName(), throwable);
                s = Result.FixState.FIX_FAILED;
            }
            result.setState(s);
        }, Platform::runLater);
    }

    private void fix(DiagnosticResult diagnosis) {
        try (Masterkey masterkeyClone = this.masterkey.copy();
             Cryptor cryptor = CryptorProvider.forScheme((CryptorProvider.Scheme)this.vaultConfig.getCipherCombo()).provide(masterkeyClone, this.csprng);){
            ((DiagnosticResult.Fix)diagnosis.getFix(this.vaultPath, this.vaultConfig, masterkeyClone, cryptor).orElseThrow(() -> new IllegalStateException("No fix for diagnosis " + diagnosis.getClass().getName() + " implemented."))).apply();
        }
        catch (Exception e) {
            throw new FixFailedException(e);
        }
    }

    public static class FixFailedException
    extends CompletionException {
        private FixFailedException(Throwable cause) {
            super(cause);
        }
    }
}

