/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading;

import java.net.URI;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoader;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface KeyLoadingStrategy
extends MasterkeyLoader {
    public static final Logger LOG = LoggerFactory.getLogger(KeyLoadingStrategy.class);

    public Masterkey loadKey(URI var1) throws MasterkeyLoadingFailedException;

    public static boolean isHubVault(String keyLoader) {
        return "hub+http".equals(keyLoader) || "hub+https".equals(keyLoader);
    }

    public static boolean isMasterkeyFileVault(String keyLoader) {
        return keyLoader.startsWith("masterkeyfile");
    }

    default public boolean recoverFromException(MasterkeyLoadingFailedException exception) {
        return false;
    }

    default public void cleanup(boolean unlockedSuccessfully) {
    }

    public static KeyLoadingStrategy failed(Exception exception) {
        return keyid -> {
            if (exception instanceof MasterkeyLoadingFailedException) {
                MasterkeyLoadingFailedException e = (MasterkeyLoadingFailedException)((Object)((Object)exception));
                throw e;
            }
            throw new MasterkeyLoadingFailedException("Can not load key", (Throwable)exception);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <E extends Exception> void use(KeyLoadingStrategyUser<E> user) throws MasterkeyLoadingFailedException, E {
        block6: {
            boolean success = false;
            try {
                user.use(this);
                success = true;
            }
            catch (MasterkeyLoadingFailedException e) {
                if (this.recoverFromException(e)) {
                    LOG.info("Unlock attempt threw {}. Reattempting...", (Object)((Object)((Object)e)).getClass().getSimpleName());
                    this.use(user);
                    break block6;
                }
                throw e;
            }
            finally {
                this.cleanup(success);
            }
        }
    }

    @FunctionalInterface
    public static interface KeyLoadingStrategyUser<E extends Exception> {
        public void use(KeyLoadingStrategy var1) throws MasterkeyLoadingFailedException, E;
    }
}

