/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.hub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HubConfig {
    public String clientId;
    public String authEndpoint;
    public String tokenEndpoint;
    public String authSuccessUrl;
    public String authErrorUrl;
    @Nullable
    public String apiBaseUrl;
    @Deprecated
    public String devicesResourceUrl;
    @JsonIgnore
    public final URIProcessors URIs = new URIProcessors();

    public URI getApiBaseUrl() {
        if (this.apiBaseUrl != null) {
            return URI.create(this.apiBaseUrl + "/").normalize();
        }
        assert (this.devicesResourceUrl != null);
        return URI.create(this.devicesResourceUrl + "/..").normalize();
    }

    public URI getWebappBaseUrl() {
        return this.getApiBaseUrl().resolve("../app/");
    }

    public class URIProcessors {
        public final URIProcessor API = this::fromApiEndpoint;

        public URI fromApiEndpoint(String path) {
            String relPath = path.startsWith("/") ? path.substring(1) : path;
            return HubConfig.this.getApiBaseUrl().resolve(relPath);
        }
    }

    @FunctionalInterface
    public static interface URIProcessor {
        public URI resolve(String var1);
    }
}

