/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.hub;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dagger.Lazy;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.settings.DeviceKey;
import org.cryptomator.cryptolib.common.P384KeyPair;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.hub.HubConfig;
import org.cryptomator.ui.keyloading.hub.ReceivedKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeyLoadingScoped
public class LegacyRegisterDeviceController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyRegisterDeviceController.class);
    private static final ObjectMapper JSON = new ObjectMapper().setDefaultLeniency(Boolean.valueOf(true));
    private static final List<Integer> EXPECTED_RESPONSE_CODES = List.of(Integer.valueOf(201), Integer.valueOf(409));
    private final Stage window;
    private final HubConfig hubConfig;
    private final String bearerToken;
    private final Lazy<Scene> registerSuccessScene;
    private final Lazy<Scene> registerFailedScene;
    private final String deviceId;
    private final P384KeyPair keyPair;
    private final CompletableFuture<ReceivedKey> result;
    private final DecodedJWT jwt;
    private final HttpClient httpClient;
    private final BooleanProperty deviceNameAlreadyExists = new SimpleBooleanProperty(false);
    public TextField deviceNameField;
    public Button registerBtn;

    @Inject
    public LegacyRegisterDeviceController(@KeyLoading Stage window, ExecutorService executor, HubConfig hubConfig, @Named(value="deviceId") String deviceId, DeviceKey deviceKey, CompletableFuture<ReceivedKey> result, @Named(value="bearerToken") AtomicReference<String> bearerToken, @FxmlScene(value=FxmlFile.HUB_LEGACY_REGISTER_SUCCESS) Lazy<Scene> registerSuccessScene, @FxmlScene(value=FxmlFile.HUB_REGISTER_FAILED) Lazy<Scene> registerFailedScene) {
        this.window = window;
        this.hubConfig = hubConfig;
        this.deviceId = deviceId;
        this.keyPair = Objects.requireNonNull(deviceKey.get());
        this.result = result;
        this.bearerToken = Objects.requireNonNull(bearerToken.get());
        this.registerSuccessScene = registerSuccessScene;
        this.registerFailedScene = registerFailedScene;
        this.jwt = JWT.decode((String)this.bearerToken);
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, this::windowClosed);
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).executor(executor).build();
    }

    public void initialize() {
        this.deviceNameField.setText(this.determineHostname());
        this.deviceNameField.textProperty().addListener(observable -> this.deviceNameAlreadyExists.set(false));
    }

    private String determineHostname() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            return Objects.requireNonNullElse(hostName, "");
        }
        catch (IOException e) {
            return "";
        }
    }

    @FXML
    public void register() {
        this.deviceNameAlreadyExists.set(false);
        this.registerBtn.setContentDisplay(ContentDisplay.LEFT);
        this.registerBtn.setDisable(true);
        URI deviceUri = URI.create(this.hubConfig.devicesResourceUrl + this.deviceId);
        byte[] deviceKey = this.keyPair.getPublic().getEncoded();
        CreateDeviceDto dto = new CreateDeviceDto();
        dto.id = this.deviceId;
        dto.name = this.deviceNameField.getText();
        dto.publicKey = Base64.getUrlEncoder().withoutPadding().encodeToString(deviceKey);
        String json = this.toJson(dto);
        HttpRequest request = HttpRequest.newBuilder(deviceUri).PUT(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).header("Authorization", "Bearer " + this.bearerToken).header("Content-Type", "application/json").build();
        ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.discarding()).thenApply(response -> {
            if (EXPECTED_RESPONSE_CODES.contains(response.statusCode())) {
                return response;
            }
            throw new RuntimeException("Server answered with unexpected status code " + response.statusCode());
        })).handleAsync((response, throwable) -> {
            if (response != null) {
                this.handleResponse((HttpResponse<Void>)response);
            } else {
                this.registrationFailed((Throwable)throwable);
            }
            return null;
        }, Platform::runLater);
    }

    private String toJson(CreateDeviceDto dto) {
        try {
            return JSON.writer().writeValueAsString((Object)dto);
        }
        catch (JacksonException e) {
            throw new IllegalStateException("Failed to serialize DTO", e);
        }
    }

    private void handleResponse(HttpResponse<Void> voidHttpResponse) {
        assert (EXPECTED_RESPONSE_CODES.contains(voidHttpResponse.statusCode()));
        if (voidHttpResponse.statusCode() == 409) {
            this.deviceNameAlreadyExists.set(true);
            this.registerBtn.setContentDisplay(ContentDisplay.TEXT_ONLY);
            this.registerBtn.setDisable(false);
        } else {
            LOG.debug("Device registration for hub instance {} successful.", (Object)this.hubConfig.authSuccessUrl);
            this.window.setScene((Scene)this.registerSuccessScene.get());
        }
    }

    private void registrationFailed(Throwable cause) {
        LOG.warn("Device registration failed.", cause);
        this.window.setScene((Scene)this.registerFailedScene.get());
        this.result.completeExceptionally(cause);
    }

    @FXML
    public void close() {
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        this.result.cancel(true);
    }

    public String getUserName() {
        return this.jwt.getClaim("email").asString();
    }

    public BooleanProperty deviceNameAlreadyExistsProperty() {
        return this.deviceNameAlreadyExists;
    }

    public boolean getDeviceNameAlreadyExists() {
        return this.deviceNameAlreadyExists.get();
    }

    private static class CreateDeviceDto {
        public String id;
        public String name;
        public final String type = "DESKTOP";
        public String publicKey;

        private CreateDeviceDto() {
        }
    }
}

