/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.masterkeyfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.Passphrase;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.common.BackupHelper;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.keyloading.masterkeyfile.ChooseMasterkeyFileComponent;
import org.cryptomator.ui.keyloading.masterkeyfile.PassphraseEntryComponent;
import org.cryptomator.ui.keyloading.masterkeyfile.PassphraseEntryResult;
import org.cryptomator.ui.unlock.UnlockCancelledException;

@KeyLoading
public class MasterkeyFileLoadingStrategy
implements KeyLoadingStrategy {
    public static final String SCHEME = "masterkeyfile";
    private final Vault vault;
    private final MasterkeyFileAccess masterkeyFileAccess;
    private final Stage window;
    private final PassphraseEntryComponent.Builder passphraseEntry;
    private final ChooseMasterkeyFileComponent.Builder masterkeyFileChoice;
    private final KeychainManager keychain;
    private final ResourceBundle resourceBundle;
    private Passphrase passphrase;
    private boolean savePassphrase;
    private boolean wrongPassphrase;

    @Inject
    public MasterkeyFileLoadingStrategy(@KeyLoading Vault vault, MasterkeyFileAccess masterkeyFileAccess, @KeyLoading Stage window, @Named(value="savedPassword") Optional<char[]> savedPassphrase, PassphraseEntryComponent.Builder passphraseEntry, ChooseMasterkeyFileComponent.Builder masterkeyFileChoice, KeychainManager keychain, ResourceBundle resourceBundle) {
        this.vault = vault;
        this.masterkeyFileAccess = masterkeyFileAccess;
        this.window = window;
        this.passphraseEntry = passphraseEntry;
        this.masterkeyFileChoice = masterkeyFileChoice;
        this.keychain = keychain;
        this.resourceBundle = resourceBundle;
        this.passphrase = savedPassphrase.map(Passphrase::new).orElse(null);
        this.savePassphrase = savedPassphrase.isPresent();
    }

    @Override
    public Masterkey loadKey(URI keyId) throws MasterkeyLoadingFailedException {
        this.window.setTitle(this.resourceBundle.getString("unlock.title").formatted(this.vault.getDisplayName()));
        Preconditions.checkArgument((boolean)SCHEME.equalsIgnoreCase(keyId.getScheme()), (Object)"Only supports keys with scheme masterkeyfile");
        try {
            Path filePath = this.vault.getPath().resolve(keyId.getSchemeSpecificPart());
            if (!Files.exists(filePath, new LinkOption[0])) {
                filePath = this.askUserForMasterkeyFilePath();
            }
            if (this.passphrase == null) {
                this.askForPassphrase();
            }
            Masterkey masterkey = this.masterkeyFileAccess.load(filePath, (CharSequence)this.passphrase);
            if (filePath.startsWith(this.vault.getPath())) {
                try {
                    BackupHelper.attemptBackup((Path)filePath);
                }
                catch (IOException e) {
                    LOG.warn("Unable to create backup for masterkey file.");
                }
            } else {
                LOG.info("Masterkey file not stored inside vault. Not creating a backup.");
            }
            return masterkey;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UnlockCancelledException("Unlock interrupted", e);
        }
    }

    @Override
    public boolean recoverFromException(MasterkeyLoadingFailedException exception) {
        if (exception instanceof InvalidPassphraseException) {
            this.wrongPassphrase = true;
            this.passphrase.destroy();
            this.passphrase = null;
            return true;
        }
        return false;
    }

    @Override
    public void cleanup(boolean unlockedSuccessfully) {
        if (unlockedSuccessfully && this.savePassphrase) {
            this.savePasswordToSystemkeychain(this.passphrase);
        }
        if (this.passphrase != null) {
            this.passphrase.destroy();
        }
    }

    private void savePasswordToSystemkeychain(Passphrase passphrase) {
        try {
            if (this.keychain.isSupported() && !this.keychain.getPassphraseStoredProperty(this.vault.getId()).get()) {
                this.keychain.storePassphrase(this.vault.getId(), this.vault.getDisplayName(), passphrase);
            }
        }
        catch (KeychainAccessException e) {
            LOG.error("Failed to store passphrase in system keychain.", (Throwable)e);
        }
    }

    private Path askUserForMasterkeyFilePath() throws InterruptedException {
        ChooseMasterkeyFileComponent comp = this.masterkeyFileChoice.build();
        Platform.runLater(() -> {
            this.window.setScene(comp.chooseMasterkeyScene());
            this.window.show();
            Window owner = this.window.getOwner();
            if (owner != null) {
                this.window.setX(owner.getX() + (owner.getWidth() - this.window.getWidth()) / 2.0);
                this.window.setY(owner.getY() + (owner.getHeight() - this.window.getHeight()) / 2.0);
            } else {
                this.window.centerOnScreen();
            }
        });
        try {
            return comp.result().get();
        }
        catch (CancellationException e) {
            throw new UnlockCancelledException("Choosing masterkey file cancelled.");
        }
        catch (ExecutionException e) {
            throw new MasterkeyLoadingFailedException("Failed to select masterkey file.", (Throwable)e);
        }
    }

    private void askForPassphrase() throws InterruptedException {
        PassphraseEntryComponent comp = this.passphraseEntry.savedPassword(this.passphrase).build();
        Platform.runLater(() -> {
            this.window.setScene(comp.passphraseEntryScene());
            this.window.show();
            Window owner = this.window.getOwner();
            if (owner != null) {
                this.window.setX(owner.getX() + (owner.getWidth() - this.window.getWidth()) / 2.0);
                this.window.setY(owner.getY() + (owner.getHeight() - this.window.getHeight()) / 2.0);
            } else {
                this.window.centerOnScreen();
            }
            if (this.wrongPassphrase) {
                Animations.createShakeWindowAnimation((Window)this.window).play();
            }
        });
        try {
            PassphraseEntryResult result = comp.result().get();
            this.passphrase = result.passphrase();
            this.savePassphrase = result.savePassphrase();
        }
        catch (CancellationException e) {
            throw new UnlockCancelledException("Password entry cancelled.");
        }
        catch (ExecutionException e) {
            throw new MasterkeyLoadingFailedException("Failed to ask for password.", (Throwable)e);
        }
    }
}

