/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MainWindowScoped
public class MainWindowController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindowController.class);
    private final Stage window;
    private final ReadOnlyObjectProperty<Vault> selectedVault;
    private final Settings settings;
    private final FxApplicationWindows appWindows;
    private final BooleanBinding updateAvailable;
    private final LicenseHolder licenseHolder;
    @FXML
    private StackPane root;

    @Inject
    public MainWindowController(@MainWindow Stage window, ObjectProperty<Vault> selectedVault, Settings settings, FxApplicationWindows appWindows, UpdateChecker updateChecker, LicenseHolder licenseHolder) {
        this.window = window;
        this.selectedVault = selectedVault;
        this.settings = settings;
        this.appWindows = appWindows;
        this.updateAvailable = updateChecker.updateAvailableProperty();
        this.licenseHolder = licenseHolder;
        updateChecker.automaticallyCheckForUpdatesIfEnabled();
    }

    @FXML
    public void initialize() {
        LOG.trace("init MainWindowController");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.root.getStyleClass().add((Object)"os-windows");
        }
        this.window.focusedProperty().addListener(this::mainWindowFocusChanged);
        int x = this.settings.windowXPosition.get();
        int y = this.settings.windowYPosition.get();
        int width = this.settings.windowWidth.get();
        int height = this.settings.windowHeight.get();
        if (this.windowPositionSaved(x, y, width, height)) {
            this.window.setX((double)x);
            this.window.setY((double)y);
            this.window.setWidth(Math.clamp((double)width, this.window.getMinWidth(), this.window.getMaxWidth()));
            this.window.setHeight(Math.clamp((double)height, this.window.getMinHeight(), this.window.getMaxHeight()));
        }
        this.window.setOnShowing(this::checkDisplayBounds);
        this.settings.windowXPosition.bind((ObservableValue)this.window.xProperty());
        this.settings.windowYPosition.bind((ObservableValue)this.window.yProperty());
        this.settings.windowWidth.bind((ObservableValue)this.window.widthProperty());
        this.settings.windowHeight.bind((ObservableValue)this.window.heightProperty());
    }

    private boolean windowPositionSaved(int x, int y, int width, int height) {
        return x != 0 || y != 0 || width != 0 || height != 0;
    }

    private void checkDisplayBounds(WindowEvent windowEvent) {
        int x = this.settings.windowXPosition.get();
        int y = this.settings.windowYPosition.get();
        int width = this.settings.windowWidth.get();
        int height = this.settings.windowHeight.get();
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getBounds();
        if (!this.isWithinDisplayBounds(x, y, width, height)) {
            LOG.debug("Resetting window position due to insufficient screen overlap");
            double centeredX = (primaryScreenBounds.getWidth() - this.window.getMinWidth()) / 2.0;
            double centeredY = (primaryScreenBounds.getHeight() - this.window.getMinHeight()) / 2.0;
            if (this.isWithinDisplayBounds((int)centeredX, (int)centeredY, width, height)) {
                this.window.setWidth(Math.clamp((double)width, this.window.getMinWidth(), this.window.getMaxWidth()));
                this.window.setHeight(Math.clamp((double)height, this.window.getMinHeight(), this.window.getMaxHeight()));
            }
            this.window.setX(centeredX);
            this.window.setY(centeredY);
        }
    }

    private boolean isWithinDisplayBounds(int x, int y, int width, int height) {
        int shrinkedX = x + 20;
        int shrinkedY = y + 5;
        int shrinkedWidth = width - 40;
        int shrinkedHeigth = height - 25;
        return this.isRectangleWithinBounds(shrinkedX, shrinkedY, 0, shrinkedHeigth) && this.isRectangleWithinBounds(shrinkedX + shrinkedWidth, shrinkedY, 0, shrinkedHeigth) && this.isRectangleWithinBounds(shrinkedX, shrinkedY, shrinkedWidth, 0) && this.isRectangleWithinBounds(shrinkedX, shrinkedY + shrinkedHeigth, shrinkedWidth, 0);
    }

    private boolean isRectangleWithinBounds(int x, int y, int width, int height) {
        return !Screen.getScreensForRectangle((double)x, (double)y, (double)width, (double)height).isEmpty();
    }

    private void mainWindowFocusChanged(Observable observable) {
        Vault v = (Vault)this.selectedVault.get();
        if (v != null) {
            VaultListManager.redetermineVaultState(v);
        }
    }

    @FXML
    public void showGeneralPreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.GENERAL);
    }

    @FXML
    public void showContributePreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.CONTRIBUTE);
    }

    @FXML
    public void showUpdatePreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.UPDATES);
    }

    public ReadOnlyBooleanProperty debugModeEnabledProperty() {
        return this.settings.debugMode;
    }

    public boolean getDebugModeEnabled() {
        return this.debugModeEnabledProperty().get();
    }

    public BooleanBinding updateAvailableProperty() {
        return this.updateAvailable;
    }

    public boolean getUpdateAvailable() {
        return this.updateAvailable.get();
    }

    public BooleanBinding licenseValidProperty() {
        return this.licenseHolder.validLicenseProperty();
    }

    public boolean getLicenseValid() {
        return this.licenseHolder.isValidLicense();
    }
}

