/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsComponent;

@MainWindowScoped
public class VaultDetailLockedController
implements FxController {
    private final ReadOnlyObjectProperty<Vault> vault;
    private final FxApplicationWindows appWindows;
    private final VaultOptionsComponent.Factory vaultOptionsWindow;
    private final Stage mainWindow;
    private final ObservableValue<Boolean> passwordSaved;

    @Inject
    VaultDetailLockedController(ObjectProperty<Vault> vault, FxApplicationWindows appWindows, VaultOptionsComponent.Factory vaultOptionsWindow, KeychainManager keychain, @MainWindow Stage mainWindow) {
        this.vault = vault;
        this.appWindows = appWindows;
        this.vaultOptionsWindow = vaultOptionsWindow;
        this.mainWindow = mainWindow;
        this.passwordSaved = Bindings.createBooleanBinding(() -> {
            Vault v = (Vault)vault.get();
            return v != null && keychain.getPassphraseStoredProperty(v.getId()).getValue() != false;
        }, (Observable[])new Observable[]{vault, keychain.getKeychainImplementation()});
    }

    @FXML
    public void unlock() {
        this.appWindows.startUnlockWorkflow((Vault)this.vault.get(), this.mainWindow);
    }

    @FXML
    public void share() {
        this.appWindows.showShareVaultWindow((Vault)this.vault.get());
    }

    @FXML
    public void showVaultOptions() {
        this.vaultOptionsWindow.create((Vault)this.vault.get()).showVaultOptionsWindow(SelectedVaultOptionsTab.ANY);
    }

    @FXML
    public void showKeyVaultOptions() {
        this.vaultOptionsWindow.create((Vault)this.vault.get()).showVaultOptionsWindow(SelectedVaultOptionsTab.KEY);
    }

    public ReadOnlyObjectProperty<Vault> vaultProperty() {
        return this.vault;
    }

    public Vault getVault() {
        return (Vault)this.vault.get();
    }

    public ObservableValue<Boolean> passwordSavedProperty() {
        return this.passwordSaved;
    }

    public boolean isPasswordSaved() {
        return (Boolean)this.passwordSaved.getValue();
    }
}

