/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;

@MainWindowScoped
public class VaultDetailMissingVaultController
implements FxController {
    private final ObjectProperty<Vault> vault;
    private final ObservableList<Vault> vaults;
    private final ResourceBundle resourceBundle;
    private final Stage window;
    private final RecoveryKeyComponent.Factory recoveryKeyWindow;
    private final Dialogs dialogs;

    @Inject
    public VaultDetailMissingVaultController(ObjectProperty<Vault> vault, ObservableList<Vault> vaults, ResourceBundle resourceBundle, @MainWindow Stage window, Dialogs dialogs, RecoveryKeyComponent.Factory recoveryKeyWindow) {
        this.vault = vault;
        this.vaults = vaults;
        this.resourceBundle = resourceBundle;
        this.window = window;
        this.recoveryKeyWindow = recoveryKeyWindow;
        this.dialogs = dialogs;
    }

    @FXML
    public void recheck() {
        VaultListManager.redetermineVaultState((Vault)this.vault.get());
    }

    @FXML
    void didClickRemoveVault() {
        this.dialogs.prepareRemoveVaultDialog(this.window, (Vault)this.vault.get(), this.vaults).build().showAndWait();
    }

    @FXML
    void restoreVaultConfig() {
        if (KeyLoadingStrategy.isHubVault((String)((Vault)this.vault.get()).getVaultSettings().lastKnownKeyLoader.get())) {
            this.dialogs.prepareContactHubVaultOwner(this.window).build().showAndWait();
        } else if (Files.exists(((Vault)this.vault.get()).getPath().resolve("masterkey.cryptomator"), new LinkOption[0])) {
            this.recoveryKeyWindow.create((Vault)this.vault.get(), this.window, (ObjectProperty<RecoveryActionType>)new SimpleObjectProperty((Object)RecoveryActionType.RESTORE_VAULT_CONFIG)).showOnboardingDialogWindow();
        } else {
            this.recoveryKeyWindow.create((Vault)this.vault.get(), this.window, (ObjectProperty<RecoveryActionType>)new SimpleObjectProperty((Object)RecoveryActionType.RESTORE_ALL)).showOnboardingDialogWindow();
        }
    }

    @FXML
    void changeLocation() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("addvaultwizard.existing.filePickerTitle"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.resourceBundle.getString("addvaultwizard.existing.filePickerMimeDesc"), new String[]{"*.cryptomator"}));
        File masterkeyFile = fileChooser.showOpenDialog((Window)this.window);
        if (masterkeyFile != null) {
            ((Vault)this.vault.get()).getVaultSettings().path.setValue((Object)masterkeyFile.toPath().toAbsolutePath().getParent());
            this.recheck();
        }
    }
}

