/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;

@MainWindowScoped
public class VaultDetailUnknownErrorController
implements FxController {
    private final ObjectProperty<Vault> vault;
    private final FxApplicationWindows appWindows;
    private final Stage errorWindow;
    private final ObservableList<Vault> vaults;
    private final Stage mainWindow;
    private final Dialogs dialogs;

    @Inject
    public VaultDetailUnknownErrorController(@MainWindow Stage mainWindow, ObjectProperty<Vault> vault, ObservableList<Vault> vaults, FxApplicationWindows appWindows, @Named(value="errorWindow") Stage errorWindow, Dialogs dialogs) {
        this.mainWindow = mainWindow;
        this.vault = vault;
        this.vaults = vaults;
        this.appWindows = appWindows;
        this.errorWindow = errorWindow;
        this.dialogs = dialogs;
    }

    @FXML
    public void showError() {
        this.appWindows.showErrorWindow(((Vault)this.vault.get()).getLastKnownException(), this.errorWindow, null);
    }

    @FXML
    public void reload() {
        VaultListManager.redetermineVaultState((Vault)this.vault.get());
    }

    @FXML
    void didClickRemoveVault() {
        this.dialogs.prepareRemoveVaultDialog(this.mainWindow, (Vault)this.vault.get(), this.vaults).build().showAndWait();
    }
}

