/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import com.google.common.base.CharMatcher;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.preferences.PreferencesScoped;
import org.cryptomator.ui.preferences.PreferencesWindow;

@PreferencesScoped
public class SupporterCertificateController
implements FxController {
    private static final String DONATE_URI = "https://cryptomator.org/donate";
    private static final String SPONSORS_URI = "https://cryptomator.org/sponsors";
    private static final String SUPPORTER_URI = "https://store.cryptomator.org/desktop";
    private final Application application;
    private final Stage window;
    private final LicenseHolder licenseHolder;
    private final Settings settings;
    private final Dialogs dialogs;
    @FXML
    private TextArea supporterCertificateField;

    @Inject
    SupporterCertificateController(Application application, @PreferencesWindow Stage window, LicenseHolder licenseHolder, Settings settings, Dialogs dialogs) {
        this.application = application;
        this.window = window;
        this.licenseHolder = licenseHolder;
        this.settings = settings;
        this.dialogs = dialogs;
    }

    @FXML
    public void initialize() {
        this.supporterCertificateField.setText((String)this.licenseHolder.getLicenseKey().orElse(null));
        this.supporterCertificateField.textProperty().addListener(this::registrationKeyChanged);
        this.supporterCertificateField.setTextFormatter(new TextFormatter(this::removeWhitespaces));
        this.settings.licenseKey.addListener((observableValue, string, newValue) -> {
            if (newValue == null) {
                this.supporterCertificateField.setText(null);
            }
        });
    }

    private TextFormatter.Change removeWhitespaces(TextFormatter.Change change) {
        if (change.isContentChange()) {
            String strippedText = CharMatcher.whitespace().removeFrom((CharSequence)change.getText());
            change.setText(strippedText);
        }
        return change;
    }

    private void registrationKeyChanged(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        this.licenseHolder.validateAndStoreLicense(newValue);
        if (!this.licenseHolder.isValidLicense()) {
            this.settings.theme.set((Object)UiTheme.LIGHT);
        }
    }

    @FXML
    public void getSupporterCertificate() {
        this.application.getHostServices().showDocument(SUPPORTER_URI);
    }

    @FXML
    public void showDonate() {
        this.application.getHostServices().showDocument(DONATE_URI);
    }

    @FXML
    public void showSponsors() {
        this.application.getHostServices().showDocument(SPONSORS_URI);
    }

    @FXML
    void didClickRemoveCert() {
        this.dialogs.prepareRemoveCertDialog(this.window, this.settings).build().showAndWait();
    }

    public LicenseHolder getLicenseHolder() {
        return this.licenseHolder;
    }
}

