/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.recovery.CryptoFsInitializer;
import org.cryptomator.common.recovery.MasterkeyService;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.recovery.RecoveryDirectory;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.controls.FormattedLabel;
import org.cryptomator.ui.controls.NiceSecurePasswordField;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RecoveryKeyScoped
public class RecoveryKeyCreationController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryKeyCreationController.class);
    private final Stage window;
    private final Lazy<Scene> successScene;
    private final Lazy<Scene> recoverykeyExpertSettingsScene;
    private final MasterkeyFileAccess masterkeyFileAccess;
    private final Vault vault;
    private final ExecutorService executor;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final StringProperty recoveryKeyProperty;
    private final FxApplicationWindows appWindows;
    public NiceSecurePasswordField passwordField;
    private final IntegerProperty shorteningThreshold;
    private final ObjectProperty<RecoveryActionType> recoverType;
    private final ResourceBundle resourceBundle;
    public FormattedLabel descriptionLabel;
    public Button cancelButton;
    public Button nextButton;
    private final VaultListManager vaultListManager;
    private final Dialogs dialogs;

    @Inject
    public RecoveryKeyCreationController(FxApplicationWindows appWindows, @RecoveryKeyWindow Stage window, @FxmlScene(value=FxmlFile.RECOVERYKEY_SUCCESS) Lazy<Scene> successScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_EXPERT_SETTINGS) Lazy<Scene> recoverykeyExpertSettingsScene, @RecoveryKeyWindow Vault vault, RecoveryKeyFactory recoveryKeyFactory, MasterkeyFileAccess masterkeyFileAccess, ExecutorService executor, @RecoveryKeyWindow StringProperty recoveryKey, @Named(value="shorteningThreshold") IntegerProperty shorteningThreshold, @Named(value="recoverType") ObjectProperty<RecoveryActionType> recoverType, VaultListManager vaultListManager, ResourceBundle resourceBundle, Dialogs dialogs) {
        this.window = window;
        this.successScene = successScene;
        this.recoverykeyExpertSettingsScene = recoverykeyExpertSettingsScene;
        this.vault = vault;
        this.executor = executor;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.recoveryKeyProperty = recoveryKey;
        this.appWindows = appWindows;
        this.recoverType = recoverType;
        this.resourceBundle = resourceBundle;
        this.masterkeyFileAccess = masterkeyFileAccess;
        this.shorteningThreshold = shorteningThreshold;
        this.vaultListManager = vaultListManager;
        this.dialogs = dialogs;
    }

    @FXML
    public void initialize() {
        if (this.recoverType.get() == RecoveryActionType.SHOW_KEY) {
            this.window.setTitle(this.resourceBundle.getString("recoveryKey.display.title"));
        } else if (this.recoverType.get() == RecoveryActionType.RESTORE_VAULT_CONFIG) {
            this.window.setTitle(this.resourceBundle.getString("recover.recoverVaultConfig.title"));
            this.descriptionLabel.formatProperty().set((Object)this.resourceBundle.getString("recoveryKey.recover.description"));
            this.cancelButton.setOnAction(actionEvent -> this.back());
            this.cancelButton.setText(this.resourceBundle.getString("generic.button.back"));
            this.nextButton.setOnAction(actionEvent -> this.restoreWithPassword());
        }
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.recoverykeyExpertSettingsScene.get());
        this.window.centerOnScreen();
    }

    @FXML
    public void createRecoveryKey() {
        RecoveryKeyCreationTask task = new RecoveryKeyCreationTask();
        task.setOnScheduled(event -> LOG.debug("Creating recovery key for {}.", (Object)this.vault.getDisplayablePath()));
        task.setOnSucceeded(event -> {
            String recoveryKey = (String)task.getValue();
            this.recoveryKeyProperty.set((Object)recoveryKey);
            this.window.setScene((Scene)this.successScene.get());
        });
        task.setOnFailed(event -> {
            if (task.getException() instanceof InvalidPassphraseException) {
                Animations.createShakeWindowAnimation((Window)this.window).play();
            } else {
                LOG.error("Creation of recovery key failed.", task.getException());
                this.appWindows.showErrorWindow(task.getException(), this.window, this.window.getScene());
            }
        });
        this.executor.submit((Runnable)((Object)task));
    }

    @FXML
    public void restoreWithPassword() {
        try (RecoveryDirectory recoveryDirectory = RecoveryDirectory.create(this.vault.getPath());){
            Path recoveryPath = recoveryDirectory.getRecoveryPath();
            Path masterkeyFilePath = this.vault.getPath().resolve("masterkey.cryptomator");
            try (Masterkey masterkey = MasterkeyService.load(this.masterkeyFileAccess, masterkeyFilePath, this.passwordField.getCharacters());){
                CryptorProvider.Scheme combo = MasterkeyService.detect(masterkey, this.vault.getPath()).orElseThrow(() -> new IllegalStateException("Could not detect combo for vault path: " + String.valueOf(this.vault.getPath())));
                CryptoFsInitializer.init(recoveryPath, masterkey, this.shorteningThreshold.get(), combo);
            }
            recoveryDirectory.moveRecoveredFile("vault.cryptomator");
            if (!this.vaultListManager.isAlreadyAdded(this.vault.getPath())) {
                this.vaultListManager.add(this.vault.getPath());
            }
            this.window.close();
            this.dialogs.prepareRecoverPasswordSuccess((Stage)this.window.getOwner()).setTitleKey("recover.recoverVaultConfig.title", new String[0]).setMessageKey("recoveryKey.recover.resetVaultConfigSuccess.message").setDescriptionKey("recoveryKey.recover.resetMasterkeyFileSuccess.description", new String[0]).build().showAndWait();
        }
        catch (InvalidPassphraseException e) {
            LOG.info("Password invalid", (Throwable)e);
            Animations.createShakeWindowAnimation((Window)this.window).play();
        }
        catch (IOException | IllegalStateException | CryptoException e) {
            LOG.error("Recovery process failed", e);
            this.appWindows.showErrorWindow(e, this.window, null);
        }
    }

    @FXML
    public void close() {
        this.window.close();
    }

    public Vault getVault() {
        return this.vault;
    }

    private class RecoveryKeyCreationTask
    extends Task<String> {
        private RecoveryKeyCreationTask() {
            this.setOnFailed(event -> LOG.error("Failed to create recovery key", this.getException()));
        }

        protected String call() throws IOException, CryptoException {
            return RecoveryKeyCreationController.this.recoveryKeyFactory.createRecoveryKey(RecoveryKeyCreationController.this.vault.getPath(), RecoveryKeyCreationController.this.passwordField.getCharacters());
        }
    }
}

