/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.Nullable;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.changepassword.NewPasswordController;
import org.cryptomator.ui.changepassword.PasswordStrengthUtil;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyCreationController;
import org.cryptomator.ui.recoverykey.RecoveryKeyDisplayController;
import org.cryptomator.ui.recoverykey.RecoveryKeyExpertSettingsController;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyOnboardingController;
import org.cryptomator.ui.recoverykey.RecoveryKeyRecoverController;
import org.cryptomator.ui.recoverykey.RecoveryKeyResetPasswordController;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeySuccessController;
import org.cryptomator.ui.recoverykey.RecoveryKeyValidateController;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@Module
abstract class RecoveryKeyModule {
    RecoveryKeyModule() {
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    @Nullable
    static VaultConfig.UnverifiedVaultConfig vaultConfig(@RecoveryKeyWindow Vault vault) {
        try {
            return vault.getVaultConfigCache().get();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    static Stage provideStage(StageFactory factory, @Named(value="keyRecoveryOwner") Stage owner) {
        Stage stage = factory.create();
        stage.setResizable(false);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)owner);
        return stage;
    }

    @Provides
    @RecoveryKeyWindow
    @RecoveryKeyScoped
    static StringProperty provideRecoveryKeyProperty() {
        return new SimpleStringProperty();
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_CREATE)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyCreationScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_CREATE);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_SUCCESS)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeySuccessScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_SUCCESS);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyRecoverScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_RECOVER);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_RESET_PASSWORD)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyResetPasswordScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_RESET_PASSWORD);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_ONBOARDING)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyOnboardingScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_ONBOARDING);
    }

    @Provides
    @FxmlScene(value=FxmlFile.RECOVERYKEY_EXPERT_SETTINGS)
    @RecoveryKeyScoped
    static Scene provideRecoveryKeyExpertSettingsScene(@RecoveryKeyWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.RECOVERYKEY_EXPERT_SETTINGS);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyCreationController.class)
    abstract FxController bindRecoveryKeyCreationController(RecoveryKeyCreationController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=RecoveryKeyDisplayController.class)
    static FxController provideRecoveryKeyDisplayController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, @RecoveryKeyWindow StringProperty recoveryKey, ResourceBundle localization) {
        return new RecoveryKeyDisplayController(window, vault.getDisplayName(), (String)recoveryKey.get(), localization);
    }

    @Provides
    @Named(value="shorteningThreshold")
    @RecoveryKeyScoped
    static IntegerProperty provideShorteningThreshold() {
        return new SimpleIntegerProperty(220);
    }

    @Provides
    @Named(value="cipherCombo")
    @RecoveryKeyScoped
    static ObjectProperty<CryptorProvider.Scheme> provideCipherCombo() {
        return new SimpleObjectProperty();
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyExpertSettingsController.class)
    abstract FxController provideRecoveryKeyExpertSettingsController(RecoveryKeyExpertSettingsController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyRecoverController.class)
    abstract FxController provideRecoveryKeyRecoverController(RecoveryKeyRecoverController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeySuccessController.class)
    abstract FxController bindRecoveryKeySuccessController(RecoveryKeySuccessController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyResetPasswordController.class)
    abstract FxController bindRecoveryKeyResetPasswordController(RecoveryKeyResetPasswordController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=RecoveryKeyOnboardingController.class)
    abstract FxController bindRecoveryKeyOnboardingController(RecoveryKeyOnboardingController var1);

    @Provides
    @IntoMap
    @FxControllerKey(value=RecoveryKeyValidateController.class)
    static FxController bindRecoveryKeyValidateController(@RecoveryKeyWindow Vault vault, @RecoveryKeyWindow @Nullable VaultConfig.UnverifiedVaultConfig vaultConfig, @RecoveryKeyWindow StringProperty recoveryKey, RecoveryKeyFactory recoveryKeyFactory, @Named(value="recoverType") ObjectProperty<RecoveryActionType> recoverType, @Named(value="cipherCombo") ObjectProperty<CryptorProvider.Scheme> cipherCombo, @Nullable MasterkeyFileAccess masterkeyFileAccess) {
        return new RecoveryKeyValidateController(vault, vaultConfig, recoveryKey, recoveryKeyFactory, masterkeyFileAccess, recoverType, cipherCombo);
    }

    @Provides
    @IntoMap
    @FxControllerKey(value=NewPasswordController.class)
    static FxController provideNewPasswordController(ResourceBundle resourceBundle, PasswordStrengthUtil strengthRater) {
        return new NewPasswordController(resourceBundle, strengthRater);
    }
}

