/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@RecoveryKeyScoped
public class RecoveryKeyOnboardingController
implements FxController {
    private final Stage window;
    private final Vault vault;
    private final Lazy<Scene> recoverykeyRecoverScene;
    private final Lazy<Scene> recoverykeyExpertSettingsScene;
    private final ObjectProperty<RecoveryActionType> recoverType;
    private final ResourceBundle resourceBundle;
    public Label titleLabel;
    public Label messageLabel;
    public Label pleaseConfirm;
    public Label secondTextDesc;
    @FXML
    private CheckBox affirmationBox;
    @FXML
    private RadioButton recoveryKeyRadio;
    @FXML
    private RadioButton passwordRadio;
    @FXML
    private Button nextButton;
    @FXML
    private VBox chooseMethodeBox;
    @FXML
    private ToggleGroup methodToggleGroup = new ToggleGroup();
    @FXML
    private HBox hBox;

    @Inject
    public RecoveryKeyOnboardingController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER) Lazy<Scene> recoverykeyRecoverScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_EXPERT_SETTINGS) Lazy<Scene> recoverykeyExpertSettingsScene, @Named(value="recoverType") ObjectProperty<RecoveryActionType> recoverType, ResourceBundle resourceBundle) {
        this.window = window;
        this.vault = vault;
        this.recoverykeyRecoverScene = recoverykeyRecoverScene;
        this.recoverykeyExpertSettingsScene = recoverykeyExpertSettingsScene;
        this.recoverType = recoverType;
        this.resourceBundle = resourceBundle;
    }

    @FXML
    public void initialize() {
        this.recoveryKeyRadio.setToggleGroup(this.methodToggleGroup);
        this.passwordRadio.setToggleGroup(this.methodToggleGroup);
        BooleanBinding showMethodSelection = Bindings.createBooleanBinding(() -> this.recoverType.get() == RecoveryActionType.RESTORE_VAULT_CONFIG, (Observable[])new Observable[]{this.recoverType});
        this.chooseMethodeBox.visibleProperty().bind((ObservableValue)showMethodSelection);
        this.chooseMethodeBox.managedProperty().bind((ObservableValue)showMethodSelection);
        this.nextButton.disableProperty().bind((ObservableValue)this.affirmationBox.selectedProperty().not().or((ObservableBooleanValue)this.methodToggleGroup.selectedToggleProperty().isNull().and((ObservableBooleanValue)showMethodSelection)));
        switch ((RecoveryActionType)((Object)this.recoverType.get())) {
            case RESTORE_MASTERKEY: {
                this.window.setTitle(this.resourceBundle.getString("recover.recoverMasterkey.title"));
                this.messageLabel.setVisible(false);
                this.messageLabel.setManaged(false);
                this.pleaseConfirm.setText(this.resourceBundle.getString("recover.onBoarding.pleaseConfirm"));
                break;
            }
            case RESTORE_ALL: {
                this.window.setTitle(this.resourceBundle.getString("recover.recoverVaultConfig.title"));
                this.messageLabel.setVisible(true);
                this.messageLabel.setManaged(true);
                this.pleaseConfirm.setText(this.resourceBundle.getString("recover.onBoarding.otherwisePleaseConfirm"));
                break;
            }
            case RESTORE_VAULT_CONFIG: {
                this.window.setTitle(this.resourceBundle.getString("recover.recoverVaultConfig.title"));
                this.messageLabel.setVisible(false);
                this.messageLabel.setManaged(false);
                this.pleaseConfirm.setText(this.resourceBundle.getString("recover.onBoarding.pleaseConfirm"));
                break;
            }
            default: {
                this.window.setTitle("");
            }
        }
        if (this.vault.getState() == VaultState.Value.ALL_MISSING) {
            this.messageLabel.setText(this.resourceBundle.getString("recover.onBoarding.allMissing.intro"));
        } else {
            this.messageLabel.setText(this.resourceBundle.getString("recover.onBoarding.intro"));
        }
        this.titleLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.recoverType.get() == RecoveryActionType.RESTORE_MASTERKEY ? this.resourceBundle.getString("recover.recoverMasterkey.title") : this.resourceBundle.getString("recover.recoverVaultConfig.title"), (Observable[])new Observable[]{this.recoverType}));
        BooleanBinding isRestoreMasterkey = Bindings.createBooleanBinding(() -> this.recoverType.get() == RecoveryActionType.RESTORE_MASTERKEY, (Observable[])new Observable[]{this.recoverType});
        this.hBox.minHeightProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)isRestoreMasterkey).then(206.0).otherwise(-1.0));
        this.secondTextDesc.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            RecoveryActionType type = (RecoveryActionType)((Object)((Object)this.recoverType.get()));
            Toggle sel = this.methodToggleGroup.getSelectedToggle();
            return switch (type) {
                case RecoveryActionType.RESTORE_VAULT_CONFIG -> this.resourceBundle.getString(sel == this.passwordRadio ? "recover.onBoarding.intro.password" : "recover.onBoarding.intro.recoveryKey");
                case RecoveryActionType.RESTORE_MASTERKEY -> this.resourceBundle.getString("recover.onBoarding.intro.masterkey.recoveryKey");
                case RecoveryActionType.RESTORE_ALL -> this.resourceBundle.getString("recover.onBoarding.intro.recoveryKey");
                default -> "";
            };
        }, (Observable[])new Observable[]{this.recoverType, this.methodToggleGroup.selectedToggleProperty()}));
        showMethodSelection.addListener((observableValue, bl, nowShown) -> {
            if (nowShown.booleanValue() && this.methodToggleGroup.getSelectedToggle() == null) {
                this.methodToggleGroup.selectToggle((Toggle)this.recoveryKeyRadio);
            }
        });
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void next() {
        switch ((RecoveryActionType)((Object)this.recoverType.get())) {
            case RESTORE_ALL: 
            case RESTORE_VAULT_CONFIG: {
                Toggle selectedToggle = this.methodToggleGroup.getSelectedToggle();
                if (selectedToggle == this.recoveryKeyRadio) {
                    this.recoverType.set((Object)RecoveryActionType.RESTORE_ALL);
                    this.window.setScene((Scene)this.recoverykeyRecoverScene.get());
                    break;
                }
                if (selectedToggle == this.passwordRadio) {
                    this.recoverType.set((Object)RecoveryActionType.RESTORE_VAULT_CONFIG);
                    this.window.setScene((Scene)this.recoverykeyExpertSettingsScene.get());
                    break;
                }
                this.window.setScene((Scene)this.recoverykeyRecoverScene.get());
                break;
            }
            case RESTORE_MASTERKEY: {
                this.window.setScene((Scene)this.recoverykeyRecoverScene.get());
                break;
            }
            default: {
                this.window.setScene((Scene)this.recoverykeyRecoverScene.get());
            }
        }
        this.window.centerOnScreen();
    }
}

