/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyValidateController;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@RecoveryKeyScoped
public class RecoveryKeyRecoverController
implements FxController {
    private final Stage window;
    private final Vault vault;
    private final Lazy<Scene> nextScene;
    private final Lazy<Scene> onBoardingScene;
    private final ResourceBundle resourceBundle;
    public ObjectProperty<RecoveryActionType> recoverType;
    @FXML
    private Button cancelButton;
    @FXML
    RecoveryKeyValidateController recoveryKeyValidateController;

    @Inject
    public RecoveryKeyRecoverController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, ResourceBundle resourceBundle, @FxmlScene(value=FxmlFile.RECOVERYKEY_RESET_PASSWORD) Lazy<Scene> resetPasswordScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_EXPERT_SETTINGS) Lazy<Scene> expertSettingsScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_ONBOARDING) Lazy<Scene> onBoardingScene, @Named(value="recoverType") ObjectProperty<RecoveryActionType> recoverType) {
        this.window = window;
        this.vault = vault;
        this.resourceBundle = resourceBundle;
        this.onBoardingScene = onBoardingScene;
        this.recoverType = recoverType;
        this.nextScene = switch ((RecoveryActionType)((Object)recoverType.get())) {
            case RecoveryActionType.RESTORE_ALL, RecoveryActionType.RESTORE_VAULT_CONFIG -> {
                window.setTitle(resourceBundle.getString("recover.recoverVaultConfig.title"));
                yield expertSettingsScene;
            }
            case RecoveryActionType.RESTORE_MASTERKEY -> {
                window.setTitle(resourceBundle.getString("recover.recoverMasterkey.title"));
                yield resetPasswordScene;
            }
            case RecoveryActionType.RESET_PASSWORD -> {
                window.setTitle(resourceBundle.getString("recoveryKey.recover.title"));
                yield resetPasswordScene;
            }
            case RecoveryActionType.SHOW_KEY -> {
                window.setTitle(resourceBundle.getString("recoveryKey.display.title"));
                yield resetPasswordScene;
            }
            default -> throw new IllegalArgumentException("Unexpected recovery action type: " + String.valueOf(recoverType.get()));
        };
    }

    @FXML
    public void initialize() {
        if (this.recoverType.get() == RecoveryActionType.RESET_PASSWORD) {
            this.cancelButton.setText(this.resourceBundle.getString("generic.button.cancel"));
        } else {
            this.cancelButton.setText(this.resourceBundle.getString("generic.button.back"));
        }
    }

    @FXML
    public void closeOrReturn() {
        switch ((RecoveryActionType)((Object)this.recoverType.get())) {
            case RESET_PASSWORD: {
                this.window.close();
                break;
            }
            case RESTORE_MASTERKEY: {
                this.window.setScene((Scene)this.onBoardingScene.get());
                this.window.centerOnScreen();
                break;
            }
            default: {
                if (this.vault.getState().equals((Object)VaultState.Value.ALL_MISSING)) {
                    this.recoverType.set((Object)RecoveryActionType.RESTORE_ALL);
                } else {
                    this.recoverType.set((Object)RecoveryActionType.RESTORE_VAULT_CONFIG);
                }
                this.window.setScene((Scene)this.onBoardingScene.get());
                this.window.centerOnScreen();
            }
        }
    }

    @FXML
    public void recover() {
        this.window.setScene((Scene)this.nextScene.get());
    }

    public RecoveryKeyValidateController getValidateController() {
        return this.recoveryKeyValidateController;
    }
}

