/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.recovery.CryptoFsInitializer;
import org.cryptomator.common.recovery.MasterkeyService;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.recovery.RecoveryDirectory;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.ui.changepassword.NewPasswordController;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RecoveryKeyScoped
public class RecoveryKeyResetPasswordController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryKeyResetPasswordController.class);
    private final Stage window;
    private final Vault vault;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final ExecutorService executor;
    private final StringProperty recoveryKey;
    private final Lazy<Scene> recoverExpertSettingsScene;
    private final Lazy<Scene> recoverykeyRecoverScene;
    private final FxApplicationWindows appWindows;
    private final MasterkeyFileAccess masterkeyFileAccess;
    private final VaultListManager vaultListManager;
    private final IntegerProperty shorteningThreshold;
    private final ObjectProperty<RecoveryActionType> recoverType;
    private final ObjectProperty<CryptorProvider.Scheme> cipherCombo;
    private final ResourceBundle resourceBundle;
    private final Dialogs dialogs;
    public NewPasswordController newPasswordController;
    public Button nextButton;

    @Inject
    public RecoveryKeyResetPasswordController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, RecoveryKeyFactory recoveryKeyFactory, ExecutorService executor, @RecoveryKeyWindow StringProperty recoveryKey, @FxmlScene(value=FxmlFile.RECOVERYKEY_EXPERT_SETTINGS) Lazy<Scene> recoverExpertSettingsScene, @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER) Lazy<Scene> recoverykeyRecoverScene, FxApplicationWindows appWindows, MasterkeyFileAccess masterkeyFileAccess, VaultListManager vaultListManager, @Named(value="shorteningThreshold") IntegerProperty shorteningThreshold, @Named(value="recoverType") ObjectProperty<RecoveryActionType> recoverType, @Named(value="cipherCombo") ObjectProperty<CryptorProvider.Scheme> cipherCombo, ResourceBundle resourceBundle, Dialogs dialogs) {
        this.window = window;
        this.vault = vault;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.executor = executor;
        this.recoveryKey = recoveryKey;
        this.recoverExpertSettingsScene = recoverExpertSettingsScene;
        this.recoverykeyRecoverScene = recoverykeyRecoverScene;
        this.appWindows = appWindows;
        this.masterkeyFileAccess = masterkeyFileAccess;
        this.vaultListManager = vaultListManager;
        this.shorteningThreshold = shorteningThreshold;
        this.cipherCombo = cipherCombo;
        this.recoverType = recoverType;
        this.resourceBundle = resourceBundle;
        this.dialogs = dialogs;
    }

    @FXML
    public void initialize() {
        switch ((RecoveryActionType)((Object)this.recoverType.get())) {
            case RESTORE_MASTERKEY: 
            case RESTORE_ALL: {
                this.nextButton.setText(this.resourceBundle.getString("recoveryKey.recover.recoverBtn"));
                break;
            }
            case RESET_PASSWORD: {
                this.nextButton.setText(this.resourceBundle.getString("recoveryKey.recover.resetBtn"));
                break;
            }
            default: {
                this.nextButton.setText(this.resourceBundle.getString("recoveryKey.recover.recoverBtn"));
            }
        }
    }

    @FXML
    public void close() {
        switch ((RecoveryActionType)((Object)this.recoverType.get())) {
            case RESTORE_ALL: {
                this.window.setScene((Scene)this.recoverExpertSettingsScene.get());
                break;
            }
            case RESTORE_MASTERKEY: 
            case RESET_PASSWORD: {
                this.window.setScene((Scene)this.recoverykeyRecoverScene.get());
                break;
            }
            default: {
                this.window.close();
            }
        }
    }

    @FXML
    public void next() {
        switch ((RecoveryActionType)((Object)this.recoverType.get())) {
            case RESTORE_ALL: {
                this.restorePassword();
                break;
            }
            case RESTORE_MASTERKEY: 
            case RESET_PASSWORD: {
                this.resetPassword();
                break;
            }
            default: {
                this.resetPassword();
            }
        }
    }

    @FXML
    public void restorePassword() {
        try (RecoveryDirectory recoveryDirectory = RecoveryDirectory.create(this.vault.getPath());){
            Path recoveryPath = recoveryDirectory.getRecoveryPath();
            MasterkeyService.recoverFromRecoveryKey((String)this.recoveryKey.get(), this.recoveryKeyFactory, recoveryPath, this.newPasswordController.passwordField.getCharacters());
            try (Masterkey masterkey = MasterkeyService.load(this.masterkeyFileAccess, recoveryPath.resolve("masterkey.cryptomator"), this.newPasswordController.passwordField.getCharacters());){
                CryptoFsInitializer.init(recoveryPath, masterkey, this.shorteningThreshold.get(), (CryptorProvider.Scheme)this.cipherCombo.get());
            }
            recoveryDirectory.moveRecoveredFile("masterkey.cryptomator");
            recoveryDirectory.moveRecoveredFile("vault.cryptomator");
            if (!this.vaultListManager.isAlreadyAdded(this.vault.getPath())) {
                this.vaultListManager.add(this.vault.getPath());
            }
            this.window.close();
            this.dialogs.prepareRecoverPasswordSuccess((Stage)this.window.getOwner()).setTitleKey("recover.recoverVaultConfig.title", new String[0]).setMessageKey("recoveryKey.recover.resetVaultConfigSuccess.message").build().showAndWait();
        }
        catch (IOException | CryptoException e) {
            LOG.error("Recovery process failed", e);
            this.appWindows.showErrorWindow(e, this.window, null);
        }
    }

    @FXML
    public void resetPassword() {
        ResetPasswordTask task = new ResetPasswordTask();
        task.setOnScheduled(workerStateEvent -> LOG.debug("Using recovery key to reset password for {}.", (Object)this.vault.getDisplayablePath()));
        task.setOnSucceeded(workerStateEvent -> {
            LOG.debug("Used recovery key to reset password for {}.", (Object)this.vault.getDisplayablePath());
            this.window.close();
            switch ((RecoveryActionType)((Object)((Object)this.recoverType.get()))) {
                case RESET_PASSWORD: {
                    this.dialogs.prepareRecoverPasswordSuccess((Stage)this.window.getOwner()).build().showAndWait();
                    break;
                }
                case RESTORE_MASTERKEY: {
                    this.dialogs.prepareRecoverPasswordSuccess((Stage)this.window.getOwner()).setTitleKey("recover.recoverMasterkey.title", new String[0]).setMessageKey("recoveryKey.recover.resetMasterkeyFileSuccess.message").build().showAndWait();
                    break;
                }
                default: {
                    this.dialogs.prepareRecoverPasswordSuccess(this.window).build().showAndWait();
                }
            }
        });
        task.setOnFailed(workerStateEvent -> {
            LOG.error("Resetting password failed.", task.getException());
            this.appWindows.showErrorWindow(task.getException(), this.window, null);
        });
        this.executor.submit((Runnable)((Object)task));
    }

    public ReadOnlyBooleanProperty passwordSufficientAndMatchingProperty() {
        return this.newPasswordController.goodPasswordProperty();
    }

    public boolean isPasswordSufficientAndMatching() {
        return this.newPasswordController.isGoodPassword();
    }

    private class ResetPasswordTask
    extends Task<Void> {
        private static final Logger LOG = LoggerFactory.getLogger(ResetPasswordTask.class);

        public ResetPasswordTask() {
            this.setOnFailed(workerStateEvent -> LOG.error("Failed to reset password", this.getException()));
        }

        protected Void call() throws IOException, IllegalArgumentException {
            RecoveryKeyResetPasswordController.this.recoveryKeyFactory.newMasterkeyFileWithPassphrase(RecoveryKeyResetPasswordController.this.vault.getPath(), (String)RecoveryKeyResetPasswordController.this.recoveryKey.get(), RecoveryKeyResetPasswordController.this.newPasswordController.passwordField.getCharacters());
            return null;
        }
    }
}

