/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.sharevault;

import dagger.Lazy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.application.Application;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.sharevault.ShareVaultScoped;
import org.cryptomator.ui.sharevault.ShareVaultWindow;

@ShareVaultScoped
public class ShareVaultController
implements FxController {
    private static final String SCHEME_PREFIX = "hub+";
    private static final String VISIT_HUB_URL = "https://cryptomator.org/hub/";
    private static final String BEST_PRACTICES_URL = "https://docs.cryptomator.org/security/best-practices/#sharing-of-vaults";
    private final Stage window;
    private final Lazy<Application> application;
    private final Vault vault;
    private final Boolean hubVault;

    @Inject
    ShareVaultController(@ShareVaultWindow Stage window, Lazy<Application> application, @ShareVaultWindow Vault vault) {
        this.window = window;
        this.application = application;
        this.vault = vault;
        this.hubVault = KeyLoadingStrategy.isHubVault((String)vault.getVaultSettings().lastKnownKeyLoader.get());
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void visitHub() {
        ((Application)this.application.get()).getHostServices().showDocument(VISIT_HUB_URL);
    }

    @FXML
    public void openHub() {
        ((Application)this.application.get()).getHostServices().showDocument(ShareVaultController.getHubUri(this.vault).toString());
    }

    @FXML
    public void visitBestPractices() {
        ((Application)this.application.get()).getHostServices().showDocument(BEST_PRACTICES_URL);
    }

    private static URI getHubUri(Vault vault) {
        try {
            URI keyId = new URI(vault.getVaultConfigCache().get().getKeyId().toString());
            assert (keyId.getScheme().startsWith(SCHEME_PREFIX));
            String path = keyId.getPath();
            int apiIdx = path.indexOf("/api/");
            if (apiIdx < 0) {
                throw new IllegalArgumentException("Path does not contain /api/: " + path);
            }
            String appPath = path.substring(0, apiIdx) + "/app/vaults";
            return new URI(keyId.getScheme().substring(SCHEME_PREFIX.length()), keyId.getAuthority(), appPath, null, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URI constructed from params known to be valid", e);
        }
    }

    public boolean isHubVault() {
        return this.hubVault;
    }
}

