/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.stats;

import java.util.Arrays;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultStats;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.WeakBindings;
import org.cryptomator.ui.stats.VaultStatisticsComponent;
import org.cryptomator.ui.stats.VaultStatisticsScoped;
import org.cryptomator.ui.stats.VaultStatisticsWindow;

@VaultStatisticsScoped
public class VaultStatisticsController
implements FxController {
    private static final int IO_SAMPLING_STEPS = 30;
    private static final double IO_SAMPLING_INTERVAL = 1.0;
    private final VaultStatisticsComponent component;
    private final VaultStats stats;
    private final XYChart.Series<Number, Number> readData;
    private final XYChart.Series<Number, Number> writeData;
    private final XYChart.Series<Number, Number> accessData;
    private final Timeline ioAnimation;
    private final LongBinding bpsRead;
    private final LongBinding bpsWritten;
    private final DoubleBinding cacheHitRate;
    private final DoubleBinding cacheHitDegrees;
    private final DoubleBinding cacheHitPercentage;
    private final LongBinding totalBytesRead;
    private final LongBinding totalBytesWritten;
    private final LongBinding totalBytesEncrypted;
    private final LongBinding totalBytesDecrypted;
    private final LongBinding filesRead;
    private final LongBinding filesWritten;
    private final LongBinding filesAccessed;
    private final LongBinding totalFilesAccessed;
    private final LongBinding bpsEncrypted;
    private final LongBinding bpsDecrypted;
    public AreaChart<Number, Number> readChart;
    public AreaChart<Number, Number> writeChart;
    public AreaChart<Number, Number> accessChart;
    public NumberAxis readChartXAxis;
    public NumberAxis readChartYAxis;
    public NumberAxis writeChartXAxis;
    public NumberAxis writeChartYAxis;
    public NumberAxis accessChartXAxis;
    public NumberAxis accessChartYAxis;

    @Inject
    public VaultStatisticsController(VaultStatisticsComponent component, @VaultStatisticsWindow Stage window, @VaultStatisticsWindow Vault vault) {
        this.component = component;
        this.stats = vault.getStats();
        this.readData = new XYChart.Series();
        this.writeData = new XYChart.Series();
        this.accessData = new XYChart.Series();
        this.bpsRead = WeakBindings.bindLong((ObservableValue<Number>)this.stats.bytesPerSecondReadProperty());
        this.bpsWritten = WeakBindings.bindLong((ObservableValue<Number>)this.stats.bytesPerSecondWrittenProperty());
        this.cacheHitRate = WeakBindings.bindDouble((ObservableValue<Number>)this.stats.cacheHitRateProperty());
        this.cacheHitDegrees = this.cacheHitRate.multiply(-270);
        this.cacheHitPercentage = this.cacheHitRate.multiply(100);
        this.totalBytesRead = WeakBindings.bindLong((ObservableValue<Number>)this.stats.totalBytesReadProperty());
        this.totalBytesWritten = WeakBindings.bindLong((ObservableValue<Number>)this.stats.totalBytesWrittenProperty());
        this.totalBytesDecrypted = WeakBindings.bindLong((ObservableValue<Number>)this.stats.totalBytesDecryptedProperty());
        this.totalBytesEncrypted = WeakBindings.bindLong((ObservableValue<Number>)this.stats.totalBytesEncryptedProperty());
        this.filesRead = WeakBindings.bindLong((ObservableValue<Number>)this.stats.filesRead());
        this.filesWritten = WeakBindings.bindLong((ObservableValue<Number>)this.stats.filesWritten());
        this.filesAccessed = WeakBindings.bindLong((ObservableValue<Number>)this.stats.filesAccessed());
        this.totalFilesAccessed = WeakBindings.bindLong((ObservableValue<Number>)this.stats.totalFilesAccessed());
        this.bpsEncrypted = WeakBindings.bindLong((ObservableValue<Number>)this.stats.bytesPerSecondEncryptedProperty());
        this.bpsDecrypted = WeakBindings.bindLong((ObservableValue<Number>)this.stats.bytesPerSecondDecryptedProperty());
        this.ioAnimation = new Timeline();
        this.ioAnimation.getKeyFrames().add((Object)new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new IoSamplingAnimationHandler(this.readData, this.writeData, this.accessData), new KeyValue[0]));
        this.ioAnimation.setCycleCount(-1);
        this.ioAnimation.play();
        window.setOnHiding(evt -> this.ioAnimation.stop());
        window.setOnShowing(evt -> this.ioAnimation.play());
    }

    @FXML
    public void initialize() {
        this.readChart.getData().addAll((Object[])new XYChart.Series[]{this.readData});
        this.writeChart.getData().addAll((Object[])new XYChart.Series[]{this.writeData});
        this.accessChart.getData().addAll((Object[])new XYChart.Series[]{this.accessData});
    }

    public LongBinding bpsReadProperty() {
        return this.bpsRead;
    }

    public long getBpsRead() {
        return this.bpsRead.get();
    }

    public LongBinding bpsWrittenProperty() {
        return this.bpsWritten;
    }

    public long getBpsWritten() {
        return this.bpsWritten.get();
    }

    public DoubleBinding cacheHitPercentageProperty() {
        return this.cacheHitPercentage;
    }

    public double getCacheHitPercentage() {
        return this.cacheHitPercentage.get();
    }

    public DoubleBinding cacheHitDegreesProperty() {
        return this.cacheHitDegrees;
    }

    public double getCacheHitDegrees() {
        return this.cacheHitDegrees.get();
    }

    public LongBinding totalBytesReadProperty() {
        return this.totalBytesRead;
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead.get();
    }

    public LongBinding totalBytesWrittenProperty() {
        return this.totalBytesWritten;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public LongBinding totalBytesEncryptedProperty() {
        return this.totalBytesEncrypted;
    }

    public long getTotalBytesEncrypted() {
        return this.totalBytesEncrypted.get();
    }

    public LongBinding totalBytesDecryptedProperty() {
        return this.totalBytesDecrypted;
    }

    public long getTotalBytesDecrypted() {
        return this.totalBytesDecrypted.get();
    }

    public LongBinding bpsEncryptedProperty() {
        return this.bpsEncrypted;
    }

    public long getBpsEncrypted() {
        return this.bpsEncrypted.get();
    }

    public LongBinding bpsDecryptedProperty() {
        return this.bpsDecrypted;
    }

    public long getBpsDecrypted() {
        return this.bpsDecrypted.get();
    }

    public LongBinding filesReadProperty() {
        return this.filesRead;
    }

    public long getFilesRead() {
        return this.filesRead.get();
    }

    public LongBinding filesWrittenProperty() {
        return this.filesWritten;
    }

    public long getFilesWritten() {
        return this.filesWritten.get();
    }

    public LongBinding filesAccessedProperty() {
        return this.filesAccessed;
    }

    public long getFilesAccessed() {
        return this.filesAccessed.get();
    }

    public LongBinding totalFilesAccessedProperty() {
        return this.totalFilesAccessed;
    }

    public long getTotalFilesAccessed() {
        return this.totalFilesAccessed.get();
    }

    private class IoSamplingAnimationHandler
    implements EventHandler<ActionEvent> {
        private long step = 30L;
        private final XYChart.Series<Number, Number> decryptedBytesRead;
        private final XYChart.Series<Number, Number> encryptedBytesWrite;
        private final XYChart.Series<Number, Number> accessedFiles;
        private final long[] maxBuf = new long[30];
        private final long[] maxAccessBuf = new long[30];

        public IoSamplingAnimationHandler(XYChart.Series<Number, Number> readData, XYChart.Series<Number, Number> writeData, XYChart.Series<Number, Number> accessData) {
            this.decryptedBytesRead = readData;
            this.encryptedBytesWrite = writeData;
            this.accessedFiles = accessData;
            for (int i = 0; i < 30; ++i) {
                this.decryptedBytesRead.getData().add((Object)new XYChart.Data((Object)i, (Object)0));
                this.encryptedBytesWrite.getData().add((Object)new XYChart.Data((Object)i, (Object)0));
                this.accessedFiles.getData().add((Object)new XYChart.Data((Object)i, (Object)0));
            }
        }

        public void handle(ActionEvent event) {
            long currentStep = this.step++;
            long decBytes = VaultStatisticsController.this.stats.bytesPerSecondReadProperty().get();
            long encBytes = VaultStatisticsController.this.stats.bytesPerSecondWrittenProperty().get();
            long accFiles = VaultStatisticsController.this.stats.filesAccessed().get();
            this.maxBuf[(int)currentStep % 30] = Math.max(decBytes, encBytes);
            long allTimeMax = Arrays.stream(this.maxBuf).max().orElse(0L);
            this.maxAccessBuf[(int)currentStep % 30] = accFiles;
            long allTimeMaxAccessedFiles = Arrays.stream(this.maxAccessBuf).max().orElse(0L);
            this.decryptedBytesRead.getData().remove(0);
            this.encryptedBytesWrite.getData().remove(0);
            this.accessedFiles.getData().remove(0);
            this.decryptedBytesRead.getData().add((Object)new XYChart.Data((Object)currentStep, (Object)decBytes));
            this.encryptedBytesWrite.getData().add((Object)new XYChart.Data((Object)currentStep, (Object)encBytes));
            this.accessedFiles.getData().add((Object)new XYChart.Data((Object)currentStep, (Object)accFiles));
            VaultStatisticsController.this.readChartXAxis.setLowerBound((double)currentStep - 30.0);
            VaultStatisticsController.this.readChartXAxis.setUpperBound((double)currentStep);
            VaultStatisticsController.this.readChartYAxis.setUpperBound((double)allTimeMax);
            VaultStatisticsController.this.writeChartXAxis.setLowerBound((double)currentStep - 30.0);
            VaultStatisticsController.this.writeChartXAxis.setUpperBound((double)currentStep);
            VaultStatisticsController.this.writeChartYAxis.setUpperBound((double)allTimeMax);
            VaultStatisticsController.this.accessChartXAxis.setLowerBound((double)currentStep - 30.0);
            VaultStatisticsController.this.accessChartXAxis.setUpperBound((double)currentStep);
            VaultStatisticsController.this.accessChartYAxis.setUpperBound((double)allTimeMaxAccessedFiles);
        }
    }
}

