/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.traymenu;

import com.google.common.base.Preconditions;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.integrations.common.CheckAvailability;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.tray.ActionItem;
import org.cryptomator.integrations.tray.SeparatorItem;
import org.cryptomator.integrations.tray.SubMenuItem;
import org.cryptomator.integrations.tray.TrayIconLoader;
import org.cryptomator.integrations.tray.TrayMenuController;
import org.cryptomator.integrations.tray.TrayMenuException;
import org.cryptomator.integrations.tray.TrayMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CheckAvailability
@Priority(value=-2147483648)
public class AwtTrayMenuController
implements TrayMenuController {
    private static final Logger LOG = LoggerFactory.getLogger(AwtTrayMenuController.class);
    private final PopupMenu menu = new PopupMenu();
    private TrayIcon trayIcon;
    private Image image;

    @CheckAvailability
    public static boolean isAvailable() {
        return SystemTray.isSupported();
    }

    public void showTrayIcon(Consumer<TrayIconLoader> iconLoader, Runnable defaultAction, String tooltip) throws TrayMenuException {
        TrayIconLoader.PngData callback = this::showTrayIconWithPngData;
        iconLoader.accept((TrayIconLoader)callback);
        this.trayIcon = new TrayIcon(this.image, tooltip, this.menu);
        this.trayIcon.setImageAutoSize(true);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.trayIcon.addActionListener(evt -> defaultAction.run());
        }
        try {
            SystemTray.getSystemTray().add(this.trayIcon);
            LOG.debug("initialized tray icon");
        }
        catch (AWTException e) {
            throw new TrayMenuException("Failed to add icon to system tray.", (Throwable)e);
        }
    }

    private void showTrayIconWithPngData(byte[] imageData) {
        this.image = Toolkit.getDefaultToolkit().createImage(imageData);
    }

    public void updateTrayIcon(Consumer<TrayIconLoader> iconLoader) {
        TrayIconLoader.PngData callback = this::updateTrayIconWithPngData;
        iconLoader.accept((TrayIconLoader)callback);
    }

    private void updateTrayIconWithPngData(byte[] imageData) {
        if (this.trayIcon == null) {
            throw new IllegalStateException("Failed to update the icon as it has not yet been added");
        }
        Image image = Toolkit.getDefaultToolkit().createImage(imageData);
        this.trayIcon.setImage(image);
    }

    public void updateTrayMenu(List<TrayMenuItem> items) {
        this.menu.removeAll();
        this.addChildren(this.menu, items);
    }

    public void onBeforeOpenMenu(final Runnable listener) {
        Preconditions.checkNotNull((Object)this.trayIcon);
        this.trayIcon.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                listener.run();
            }
        });
    }

    private void addChildren(Menu menu, List<TrayMenuItem> items) {
        block5: for (TrayMenuItem item : items) {
            TrayMenuItem trayMenuItem;
            Objects.requireNonNull(item);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ActionItem.class, SeparatorItem.class, SubMenuItem.class}, (TrayMenuItem)trayMenuItem, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ActionItem a = (ActionItem)trayMenuItem;
                    MenuItem menuItem = new MenuItem(a.title());
                    menuItem.addActionListener(evt -> a.action().run());
                    menuItem.setEnabled(a.enabled());
                    menu.add(menuItem);
                    continue block5;
                }
                case 1: {
                    SeparatorItem s = (SeparatorItem)trayMenuItem;
                    menu.addSeparator();
                    continue block5;
                }
                case 2: 
            }
            SubMenuItem s = (SubMenuItem)trayMenuItem;
            Menu submenu = new Menu(s.title());
            this.addChildren(submenu, s.items());
            menu.add(submenu);
        }
    }
}

