/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.ObservableUtil;
import org.cryptomator.common.mount.HideawayNotDirectoryException;
import org.cryptomator.common.mount.IllegalMountPointException;
import org.cryptomator.common.mount.MountPointCleanupFailedException;
import org.cryptomator.common.mount.MountPointInUseException;
import org.cryptomator.common.mount.MountPointNotEmptyDirectoryException;
import org.cryptomator.common.mount.MountPointNotExistingException;
import org.cryptomator.common.mount.MountPointNotSupportedException;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.FormattedLabel;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockWindow;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;

@UnlockScoped
public class UnlockInvalidMountPointController
implements FxController {
    private final Stage window;
    private final Vault vault;
    private final FxApplicationWindows appWindows;
    private final ObservableValue<ExceptionType> exceptionType;
    private final ObservableValue<Path> exceptionPath;
    private final ObservableValue<String> exceptionMessage;
    private final ObservableValue<Path> hideawayPath;
    private final ObservableValue<String> format;
    private final ObservableValue<Boolean> showPreferences;
    private final ObservableValue<Boolean> showVaultOptions;
    public FormattedLabel dialogDescription;

    @Inject
    UnlockInvalidMountPointController(@UnlockWindow Stage window, @UnlockWindow Vault vault, @UnlockWindow ObjectProperty<IllegalMountPointException> illegalMountPointException, FxApplicationWindows appWindows, ResourceBundle resourceBundle) {
        this.window = window;
        this.vault = vault;
        this.appWindows = appWindows;
        this.exceptionType = illegalMountPointException.map(this::getExceptionType);
        this.exceptionPath = illegalMountPointException.map(IllegalMountPointException::getMountpoint);
        this.exceptionMessage = illegalMountPointException.map(Throwable::getMessage);
        this.hideawayPath = illegalMountPointException.map(e -> {
            Path path;
            if (e instanceof HideawayNotDirectoryException) {
                HideawayNotDirectoryException haeExc = (HideawayNotDirectoryException)e;
                path = haeExc.getHideaway();
            } else {
                path = null;
            }
            return path;
        });
        this.format = ObservableUtil.mapWithDefault(this.exceptionType, type -> resourceBundle.getString(type.translationKey), "");
        this.showPreferences = ObservableUtil.mapWithDefault(this.exceptionType, type -> type.action == ButtonAction.SHOW_PREFERENCES, false);
        this.showVaultOptions = ObservableUtil.mapWithDefault(this.exceptionType, type -> type.action == ButtonAction.SHOW_VAULT_OPTIONS, false);
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void closeAndOpenPreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.VOLUME);
        this.window.close();
    }

    @FXML
    public void closeAndOpenVaultOptions() {
        this.appWindows.showVaultOptionsWindow(this.vault, SelectedVaultOptionsTab.MOUNT);
        this.window.close();
    }

    private ExceptionType getExceptionType(Throwable unlockException) {
        Throwable throwable = unlockException;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MountPointNotSupportedException.class, MountPointNotExistingException.class, MountPointInUseException.class, HideawayNotDirectoryException.class, MountPointCleanupFailedException.class, MountPointNotEmptyDirectoryException.class}, (Throwable)throwable2, n)) {
            case 0 -> {
                MountPointNotSupportedException x = (MountPointNotSupportedException)throwable2;
                yield ExceptionType.NOT_SUPPORTED;
            }
            case 1 -> {
                MountPointNotExistingException x = (MountPointNotExistingException)throwable2;
                yield ExceptionType.NOT_EXISTING;
            }
            case 2 -> {
                MountPointInUseException x = (MountPointInUseException)throwable2;
                yield ExceptionType.IN_USE;
            }
            case 3 -> {
                HideawayNotDirectoryException x = (HideawayNotDirectoryException)throwable2;
                yield ExceptionType.HIDEAWAY_NOT_DIR;
            }
            case 4 -> {
                MountPointCleanupFailedException x = (MountPointCleanupFailedException)throwable2;
                yield ExceptionType.COULD_NOT_BE_CLEARED;
            }
            case 5 -> {
                MountPointNotEmptyDirectoryException x = (MountPointNotEmptyDirectoryException)throwable2;
                yield ExceptionType.NOT_EMPTY_DIRECTORY;
            }
            default -> ExceptionType.GENERIC;
        };
    }

    public Path getExceptionPath() {
        return (Path)this.exceptionPath.getValue();
    }

    public ObservableValue<Path> exceptionPathProperty() {
        return this.exceptionPath;
    }

    public String getFormat() {
        return (String)this.format.getValue();
    }

    public ObservableValue<String> formatProperty() {
        return this.format;
    }

    public String getExceptionMessage() {
        return (String)this.exceptionMessage.getValue();
    }

    public ObservableValue<String> exceptionMessageProperty() {
        return this.exceptionMessage;
    }

    public Path getHideawayPath() {
        return (Path)this.hideawayPath.getValue();
    }

    public ObservableValue<Path> hideawayPathProperty() {
        return this.hideawayPath;
    }

    public Boolean getShowPreferences() {
        return (Boolean)this.showPreferences.getValue();
    }

    public ObservableValue<Boolean> showPreferencesProperty() {
        return this.showPreferences;
    }

    public Boolean getShowVaultOptions() {
        return (Boolean)this.showVaultOptions.getValue();
    }

    public ObservableValue<Boolean> showVaultOptionsProperty() {
        return this.showVaultOptions;
    }

    private static enum ExceptionType {
        NOT_SUPPORTED("unlock.error.customPath.description.notSupported", ButtonAction.SHOW_PREFERENCES),
        NOT_EXISTING("unlock.error.customPath.description.notExists", ButtonAction.SHOW_VAULT_OPTIONS),
        IN_USE("unlock.error.customPath.description.inUse", ButtonAction.SHOW_VAULT_OPTIONS),
        HIDEAWAY_NOT_DIR("unlock.error.customPath.description.hideawayNotDir", ButtonAction.SHOW_VAULT_OPTIONS),
        COULD_NOT_BE_CLEARED("unlock.error.customPath.description.couldNotBeCleaned", ButtonAction.SHOW_VAULT_OPTIONS),
        NOT_EMPTY_DIRECTORY("unlock.error.customPath.description.notEmptyDir", ButtonAction.SHOW_VAULT_OPTIONS),
        GENERIC("unlock.error.customPath.description.generic", ButtonAction.SHOW_PREFERENCES);

        private final String translationKey;
        private final ButtonAction action;

        private ExceptionType(String translationKey, ButtonAction action) {
            this.translationKey = translationKey;
            this.action = action;
        }
    }

    private static enum ButtonAction {
        SHOW_PREFERENCES,
        SHOW_VAULT_OPTIONS;

    }
}

