/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.mount.IllegalMountPointException;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.keyloading.KeyLoadingComponent;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;
import org.cryptomator.ui.unlock.UnlockInvalidMountPointController;
import org.cryptomator.ui.unlock.UnlockRequiresRestartController;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockSuccessController;
import org.cryptomator.ui.unlock.UnlockWindow;
import org.jetbrains.annotations.Nullable;

@Module(subcomponents={KeyLoadingComponent.class, RecoveryKeyComponent.class})
abstract class UnlockModule {
    UnlockModule() {
    }

    @Provides
    @UnlockWindow
    @UnlockScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @UnlockWindow
    @UnlockScoped
    static Stage provideStage(StageFactory factory, @UnlockWindow Vault vault, @Named(value="unlockWindowOwner") @Nullable Stage owner) {
        Stage stage = factory.create();
        stage.setTitle(vault.getDisplayName());
        stage.setResizable(false);
        if (owner != null) {
            stage.initOwner((Window)owner);
            stage.initModality(Modality.WINDOW_MODAL);
        } else {
            stage.initModality(Modality.APPLICATION_MODAL);
        }
        return stage;
    }

    @Provides
    @UnlockWindow
    @UnlockScoped
    static KeyLoadingStrategy provideKeyLoadingStrategy(KeyLoadingComponent.Builder compBuilder, @UnlockWindow Vault vault, @UnlockWindow Stage window) {
        return compBuilder.vault(vault).window(window).build().keyloadingStrategy();
    }

    @Provides
    @UnlockWindow
    @UnlockScoped
    static ObjectProperty<IllegalMountPointException> illegalMountPointException() {
        return new SimpleObjectProperty();
    }

    @Provides
    @FxmlScene(value=FxmlFile.UNLOCK_SUCCESS)
    @UnlockScoped
    static Scene provideUnlockSuccessScene(@UnlockWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.UNLOCK_SUCCESS);
    }

    @Provides
    @FxmlScene(value=FxmlFile.UNLOCK_INVALID_MOUNT_POINT)
    @UnlockScoped
    static Scene provideInvalidMountPointScene(@UnlockWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.UNLOCK_INVALID_MOUNT_POINT);
    }

    @Provides
    @FxmlScene(value=FxmlFile.UNLOCK_REQUIRES_RESTART)
    @UnlockScoped
    static Scene provideRestartRequiredScene(@UnlockWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.UNLOCK_REQUIRES_RESTART);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=UnlockSuccessController.class)
    abstract FxController bindUnlockSuccessController(UnlockSuccessController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=UnlockInvalidMountPointController.class)
    abstract FxController bindUnlockInvalidMountPointController(UnlockInvalidMountPointController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=UnlockRequiresRestartController.class)
    abstract FxController bindUnlockRequiresRestartController(UnlockRequiresRestartController var1);
}

