/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.updatereminder;

import java.time.Instant;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.updatereminder.UpdateReminderScoped;
import org.cryptomator.ui.updatereminder.UpdateReminderWindow;

@UpdateReminderScoped
public class UpdateReminderController
implements FxController {
    private final Stage window;
    private final Settings settings;
    private final UpdateChecker updateChecker;

    @Inject
    UpdateReminderController(@UpdateReminderWindow Stage window, Settings settings, UpdateChecker updateChecker) {
        this.window = window;
        this.settings = settings;
        this.updateChecker = updateChecker;
    }

    @FXML
    public void initialize() {
        this.settings.lastUpdateCheckReminder.set((Object)Instant.now());
    }

    @FXML
    public void cancel() {
        this.window.close();
    }

    @FXML
    public void once() {
        this.updateChecker.checkForUpdatesNow();
        this.window.close();
    }

    @FXML
    public void automatically() {
        this.updateChecker.checkForUpdatesNow();
        this.settings.checkForUpdates.set(true);
        this.window.close();
    }
}

