/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.vaultoptions;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.recovery.RecoveryActionType;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.changepassword.ChangePasswordComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.forgetpassword.ForgetPasswordComponent;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;
import org.cryptomator.ui.vaultoptions.VaultOptionsScoped;
import org.cryptomator.ui.vaultoptions.VaultOptionsWindow;

@VaultOptionsScoped
public class MasterkeyOptionsController
implements FxController {
    private final Vault vault;
    private final Stage window;
    private final ChangePasswordComponent.Builder changePasswordWindow;
    private final RecoveryKeyComponent.Factory recoveryKeyWindow;
    private final ForgetPasswordComponent.Builder forgetPasswordWindow;
    private final KeychainManager keychain;
    private final ObservableValue<Boolean> passwordSaved;

    @Inject
    MasterkeyOptionsController(@VaultOptionsWindow Vault vault, @VaultOptionsWindow Stage window, ChangePasswordComponent.Builder changePasswordWindow, RecoveryKeyComponent.Factory recoveryKeyWindow, ForgetPasswordComponent.Builder forgetPasswordWindow, KeychainManager keychain) {
        this.vault = vault;
        this.window = window;
        this.changePasswordWindow = changePasswordWindow;
        this.recoveryKeyWindow = recoveryKeyWindow;
        this.forgetPasswordWindow = forgetPasswordWindow;
        this.keychain = keychain;
        this.passwordSaved = keychain.isSupported() && !keychain.isLocked() ? keychain.getPassphraseStoredProperty(vault.getId()).orElse((Object)false) : new SimpleBooleanProperty(false);
    }

    @FXML
    public void changePassword() {
        this.changePasswordWindow.vault(this.vault).owner(this.window).build().showChangePasswordWindow();
    }

    @FXML
    public void showRecoveryKey() {
        this.recoveryKeyWindow.create(this.vault, this.window, (ObjectProperty<RecoveryActionType>)new SimpleObjectProperty((Object)RecoveryActionType.SHOW_KEY)).showRecoveryKeyCreationWindow();
    }

    @FXML
    public void showRecoverVaultDialog() {
        this.recoveryKeyWindow.create(this.vault, this.window, (ObjectProperty<RecoveryActionType>)new SimpleObjectProperty((Object)RecoveryActionType.RESET_PASSWORD)).showRecoveryKeyRecoverWindow();
    }

    @FXML
    public void showForgetPasswordDialog() {
        assert (this.keychain.isSupported());
        this.forgetPasswordWindow.vault(this.vault).owner(this.window).build().showForgetPassword();
    }

    public ObservableValue<Boolean> passwordSavedProperty() {
        return this.passwordSaved;
    }

    public boolean isPasswordSaved() {
        return (Boolean)this.passwordSaved.getValue();
    }
}

