/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind;

import java.lang.ref.WeakReference;
import java.util.List;
import javafx.beans.WeakListener;
import javafx.collections.ListChangeListener;

class ListContentBinding<E>
implements ListChangeListener<E>,
WeakListener {
    private final WeakReference<List<E>> listRef;

    public ListContentBinding(List<E> list) {
        this.listRef = new WeakReference<List<E>>(list);
    }

    public void onChanged(ListChangeListener.Change<? extends E> change) {
        List list = (List)this.listRef.get();
        if (list == null) {
            change.getList().removeListener((ListChangeListener)this);
        } else {
            while (change.next()) {
                if (change.wasPermutated()) {
                    list.subList(change.getFrom(), change.getTo()).clear();
                    list.addAll(change.getFrom(), change.getList().subList(change.getFrom(), change.getTo()));
                    continue;
                }
                if (change.wasRemoved()) {
                    list.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                }
                if (!change.wasAdded()) continue;
                list.addAll(change.getFrom(), change.getAddedSubList());
            }
        }
    }

    public boolean wasGarbageCollected() {
        return this.listRef.get() == null;
    }

    public int hashCode() {
        List list = (List)this.listRef.get();
        return list == null ? 0 : list.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        List list1 = (List)this.listRef.get();
        if (list1 == null) {
            return false;
        }
        if (obj instanceof ListContentBinding) {
            ListContentBinding other = (ListContentBinding)obj;
            List list2 = (List)other.listRef.get();
            return list1 == list2;
        }
        return false;
    }
}

