/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.filters;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.cryptomator.webdav.core.filters.HttpFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostRequestBlockingFilter
implements HttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PostRequestBlockingFilter.class);
    private static final String POST_METHOD = "POST";

    @Override
    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isPost(request)) {
            LOG.warn("Blocked POST request to {}", (Object)request.getRequestURI());
            response.sendError(405);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)new FilteredResponse(response));
        }
    }

    private boolean isPost(HttpServletRequest request) {
        return POST_METHOD.equalsIgnoreCase(request.getMethod());
    }

    private static class FilteredResponse
    extends HttpServletResponseWrapper {
        public FilteredResponse(HttpServletResponse response) {
            super(response);
        }

        public void addHeader(String name, String value) {
            if (this.isAllowHeader(name)) {
                super.setHeader(name, this.removePost(value));
            } else {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (this.isAllowHeader(name)) {
                super.setHeader(name, this.removePost(value));
            } else {
                super.setHeader(name, value);
            }
        }

        private String removePost(String value) {
            return Arrays.stream(value.split("\\s*,\\s*")).filter(Predicate.isEqual(PostRequestBlockingFilter.POST_METHOD).negate()).collect(Collectors.joining(", "));
        }

        private boolean isAllowHeader(String name) {
            return "allow".equalsIgnoreCase(name);
        }
    }
}

